/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.plugin.ha.PluginEventType;

public class PluginOperation {
    public static final String SEPARATOR = ":";
    private final PluginEventType eventType;
    private final String pluginKey;
    private final String moduleKey;

    public PluginOperation(String pluginEventinfo) {
        this.eventType = this.getEventTypeFromSupplementalInfo(pluginEventinfo);
        String completeKey = this.getKeyFromSupplementalInfo(pluginEventinfo);
        this.pluginKey = this.getPluginKeyFromKey(completeKey);
        this.moduleKey = this.getModuleKeyFromKey(completeKey);
    }

    private String getModuleKeyFromKey(String completeKey) {
        String[] keys = completeKey.split(SEPARATOR);
        return keys.length > 1 ? keys[1] : null;
    }

    private String getPluginKeyFromKey(String completeKey) {
        return completeKey.split(SEPARATOR)[0];
    }

    private String getKeyFromSupplementalInfo(String pluginEventInfo) {
        return pluginEventInfo.substring(pluginEventInfo.indexOf("-") + 1);
    }

    private PluginEventType getEventTypeFromSupplementalInfo(String pluginEventinfo) {
        return PluginEventType.valueOf(pluginEventinfo.substring(0, pluginEventinfo.indexOf("-")));
    }

    PluginEventType getPluginEventType() {
        return this.eventType;
    }

    String getPluginKey() {
        return this.pluginKey;
    }

    String getModuleKey() {
        return this.moduleKey;
    }

    String getCompleteKey() {
        return this.moduleKey != null ? this.pluginKey + SEPARATOR + this.moduleKey : this.pluginKey;
    }
}

