/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.bigpipe;

import com.atlassian.jira.plugin.bigpipe.BigPipePriorityConfigurer;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalPriorityConfigurer
implements BigPipePriorityConfigurer {
    @Override
    @Nullable
    public Integer calculatePriority(@Nonnull ResourceDescriptor resource, @Nonnull Map<String, ?> context) {
        Integer priority;
        String priorityStr = resource.getParameter("bigPipePriority");
        if (Strings.isNullOrEmpty((String)priorityStr)) {
            priority = null;
        } else {
            try {
                priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("Invalid bigPipePriority: " + priorityStr, (Throwable)e);
            }
        }
        return priority;
    }
}

