/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.bigpipe;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.bigpipe.BigPipePriorityConfigurer;
import com.atlassian.jira.plugin.bigpipe.BigPipeService;
import com.atlassian.jira.plugin.bigpipe.GlobalPriorityConfigurer;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.DefaultWebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.EmbeddedTemplateWebPanel;
import com.atlassian.plugin.web.model.ResourceTemplateWebPanel;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class BigPipeWebPanelModuleDescriptor
extends DefaultWebPanelModuleDescriptor {
    private static final String FEATURE_BIG_PIPE_KILLSWITCH = "com.atlassian.jira.config.BIG_PIPE_KILLSWITCH";
    static final String FEATURE_WEB_PANEL_METRICS = "com.atlassian.jira.config.WEB_PANEL_METRICS";
    private static final String PARAM_BIG_PIPE_ID = "bigPipeId";
    static final String PARAM_BIG_PIPE_PRIORITY = "bigPipePriority";
    private static final String PARM_BIG_PIPE_PRIORITY_CONFIGURER = "bigPipePriorityConfigurer";
    private static final String NAME_BIG_PIPE = "bigPipe";
    private final BigPipeService bigPipeService;
    final HostContainer hostContainer;
    private Optional<ResourceDescriptor> bigPipeResource;
    private final FeatureManager featureManager;
    private final ServerMetricsDetailCollector detailCollector;

    public BigPipeWebPanelModuleDescriptor(HostContainer hostContainer, ModuleFactory moduleClassFactory, WebInterfaceManager webInterfaceManager, BigPipeService bigPipeService, FeatureManager featureManager, ServerMetricsDetailCollector detailCollector) {
        super(hostContainer, moduleClassFactory, webInterfaceManager);
        this.bigPipeService = bigPipeService;
        this.hostContainer = hostContainer;
        this.featureManager = featureManager;
        this.detailCollector = detailCollector;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.bigPipeResource = this.getBigPipeResource();
    }

    public WebPanel getModule() {
        if (this.bigPipeResource.isPresent() && this.bigPipeService.isBigPipeEnabled()) {
            String bigPipeId = this.bigPipeResource.get().getParameter(PARAM_BIG_PIPE_ID);
            String configurerClassName = this.bigPipeResource.get().getParameter(PARM_BIG_PIPE_PRIORITY_CONFIGURER);
            if (Strings.isNullOrEmpty((String)configurerClassName)) {
                configurerClassName = GlobalPriorityConfigurer.class.getName();
            }
            BigPipePriorityConfigurer priorityConfigurer = this.loadPriorityConfigurer(configurerClassName);
            WebPanel placeholderBigPipePanel = this.metricsRecordingPlaceholderPanel(this.placeholderBigPipePanel(this.bigPipeResource.get()));
            return new BigPipeDelegatingWebPanel(bigPipeId, priorityConfigurer, this.bigPipeResource.get(), this.metricsRecordingBigPipeContentPanel(super.getModule()), placeholderBigPipePanel);
        }
        return this.metricsRecordingStandardPanel(super.getModule());
    }

    private WebPanel metricsRecordingStandardPanel(WebPanel base) {
        if (this.featureManager.isEnabled(FEATURE_WEB_PANEL_METRICS)) {
            return new MetricsRecordingWebPanel(base, "panel." + this.getKey());
        }
        return base;
    }

    private WebPanel metricsRecordingPlaceholderPanel(WebPanel base) {
        if (this.featureManager.isEnabled(FEATURE_WEB_PANEL_METRICS)) {
            return new MetricsRecordingWebPanel(base, "placeholder.panel." + this.getKey());
        }
        return base;
    }

    private WebPanel metricsRecordingBigPipeContentPanel(WebPanel base) {
        if (this.featureManager.isEnabled(FEATURE_WEB_PANEL_METRICS)) {
            return new MetricsRecordingWebPanel(base, "content.panel." + this.getKey());
        }
        return base;
    }

    private BigPipePriorityConfigurer loadPriorityConfigurer(String className) {
        try {
            Class<BigPipePriorityConfigurer> providerClass;
            try {
                providerClass = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                try {
                    providerClass = Class.forName(className, true, BigPipeWebPanelModuleDescriptor.class.getClassLoader()).asSubclass(BigPipePriorityConfigurer.class);
                }
                catch (ClassNotFoundException ex) {
                    e.addSuppressed(ex);
                    throw e;
                }
            }
            return PluginInjector.newInstance(providerClass, this.plugin);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load bigpipe priority configurer '" + className + "' in plugin " + this.plugin, e);
        }
    }

    private WebPanel placeholderBigPipePanel(ResourceDescriptor bigPipeResource) {
        String filename = bigPipeResource.getLocation();
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            ResourceTemplateWebPanel panel = (ResourceTemplateWebPanel)this.hostContainer.create(ResourceTemplateWebPanel.class);
            panel.setResourceFilename(filename);
            panel.setResourceType(this.getRequiredResourceType(bigPipeResource));
            panel.setPlugin(this.getPlugin());
            return panel;
        }
        String body = (String)Preconditions.checkNotNull((Object)bigPipeResource.getContent());
        EmbeddedTemplateWebPanel panel = (EmbeddedTemplateWebPanel)this.hostContainer.create(EmbeddedTemplateWebPanel.class);
        panel.setTemplateBody(body);
        panel.setResourceType(this.getRequiredResourceType(bigPipeResource));
        panel.setPlugin(this.getPlugin());
        return panel;
    }

    private Optional<ResourceDescriptor> getBigPipeResource() {
        return this.getResourceDescriptors().stream().filter(r -> NAME_BIG_PIPE.equals(r.getName())).findFirst().map(r -> {
            if (StringUtils.isBlank((CharSequence)r.getParameter(PARAM_BIG_PIPE_ID))) {
                throw new PluginParseException("Resource element with name 'bigPipe' is lacking a bigPipeId parameter.");
            }
            return r;
        });
    }

    private String getRequiredResourceType(ResourceDescriptor resource) {
        String type = resource.getType();
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new PluginParseException("Resource element is lacking a type attribute.");
        }
        return type;
    }

    private class BigPipeDelegatingWebPanel
    implements WebPanel {
        private final String resourceId;
        private final BigPipePriorityConfigurer priorityConfigurer;
        private final ResourceDescriptor resourceDescriptor;
        private final WebPanel delegate;
        private final WebPanel placeholderBigPipePanel;

        private BigPipeDelegatingWebPanel(String resourceId, BigPipePriorityConfigurer priorityConfigurer, ResourceDescriptor resourceDescriptor, WebPanel delegate, WebPanel placeholderBigPipePanel) {
            this.resourceId = resourceId;
            this.priorityConfigurer = priorityConfigurer;
            this.resourceDescriptor = resourceDescriptor;
            this.delegate = delegate;
            this.placeholderBigPipePanel = placeholderBigPipePanel;
        }

        public String getHtml(Map<String, Object> context) {
            if (this.useBigPipe()) {
                Integer priority = this.priorityConfigurer.calculatePriority(this.resourceDescriptor, Collections.unmodifiableMap(context));
                BigPipeWebPanelModuleDescriptor.this.bigPipeService.pipeContent(this.resourceId, priority, (Supplier<String>)((Supplier)() -> this.delegate.getHtml(context)));
                return this.placeholderBigPipePanel.getHtml(context);
            }
            return this.delegate.getHtml(BigPipeWebPanelModuleDescriptor.this.getContextProvider().getContextMap((Map)Maps.newHashMap(context)));
        }

        public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
            if (this.useBigPipe()) {
                Integer priority = this.priorityConfigurer.calculatePriority(this.resourceDescriptor, Collections.unmodifiableMap(context));
                BigPipeWebPanelModuleDescriptor.this.bigPipeService.pipeContent(this.resourceId, priority, (Supplier<String>)((Supplier)() -> {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        this.delegate.writeHtml((Writer)stringWriter, context);
                        return stringWriter.toString();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
                this.placeholderBigPipePanel.writeHtml(writer, context);
            } else {
                this.delegate.writeHtml(writer, BigPipeWebPanelModuleDescriptor.this.getContextProvider().getContextMap((Map)Maps.newHashMap(context)));
            }
        }

        private boolean useBigPipe() {
            HttpServletRequest request = ExecutingHttpRequest.get();
            if ("xmlhttprequest".equalsIgnoreCase(request.getHeader("X-Requested-With"))) {
                return false;
            }
            if (Boolean.TRUE.equals(request.getAttribute("is_rest_request"))) {
                return false;
            }
            return !BigPipeWebPanelModuleDescriptor.this.featureManager.isEnabled(BigPipeWebPanelModuleDescriptor.FEATURE_BIG_PIPE_KILLSWITCH);
        }
    }

    private class MetricsRecordingWebPanel
    implements WebPanel {
        private final String metricName;
        private final WebPanel delegate;

        public MetricsRecordingWebPanel(WebPanel delegate, String metricName) {
            this.delegate = delegate;
            this.metricName = metricName;
        }

        public String getHtml(Map<String, Object> context) {
            BigPipeWebPanelModuleDescriptor.this.detailCollector.checkpointReached(this.metricName + ".start");
            String html = this.delegate.getHtml(context);
            BigPipeWebPanelModuleDescriptor.this.detailCollector.checkpointReached(this.metricName + ".finish");
            return html;
        }

        public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
            BigPipeWebPanelModuleDescriptor.this.detailCollector.checkpointReached(this.metricName + ".start");
            this.delegate.writeHtml(writer, context);
            BigPipeWebPanelModuleDescriptor.this.detailCollector.checkpointReached(this.metricName + ".finish");
        }
    }
}

