/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.JiraPluginTransactionEndEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginTransactionEndEvent;
import com.atlassian.plugin.event.events.PluginTransactionStartEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTransactionListener {
    private static final Logger log = LoggerFactory.getLogger(PluginTransactionListener.class);
    private static final String SYSTEM_PROPERTY_STATS_FREQUENCY_MIN = "com.atlassian.jira.plugin.event.merger.stats.frequency.min";
    static final int MAX_EVENTS_IN_TRANSACTION_LOGGED = 1000;
    private final EventPublisher eventPublisher;
    private final ReplicationPauserManager replicationPauserManager;
    private final ScheduledExecutorService executorService;
    final AtomicLong statsNumberStartEvents = new AtomicLong();
    final AtomicLong statsNumberEndEvents = new AtomicLong();
    final AtomicLong statsNumberSendEvents = new AtomicLong();
    final AtomicLong statsNumberEventsInTransactions = new AtomicLong();

    PluginTransactionListener(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager, ScheduledExecutorService executorService, JiraProperties jiraProperties) {
        this.eventPublisher = eventPublisher;
        this.replicationPauserManager = replicationPauserManager;
        this.executorService = executorService;
        eventPublisher.register((Object)this);
        long statsFrequencyMin = jiraProperties.getInteger(SYSTEM_PROPERTY_STATS_FREQUENCY_MIN, Integer.valueOf(5)).intValue();
        this.executorService.scheduleAtFixedRate(this::logStats, statsFrequencyMin, statsFrequencyMin, TimeUnit.MINUTES);
    }

    public PluginTransactionListener(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager, JiraProperties jiraProperties) {
        this(eventPublisher, replicationPauserManager, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("plugin-transaction-%d").build()), jiraProperties);
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        log.info("[plugin-transaction] Shutting down");
        this.executorService.shutdownNow();
    }

    synchronized void logStats() {
        try {
            log.info("[plugin-transaction] numberStartEvents:{}, numberEndEvents:{}, numberSendEvents:{}, numberEventsInTransactions:{}", new Object[]{this.statsNumberStartEvents.get(), this.statsNumberEndEvents.get(), this.statsNumberSendEvents.get(), this.statsNumberEventsInTransactions.get()});
        }
        catch (Throwable throwable) {
            log.error("Error in plugin transaction listener stats:{}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    @EventListener
    public void onPluginTransactionStartEvent(PluginTransactionStartEvent pluginTransactionStartEvent) {
        log.debug("[plugin-transaction] transaction starts with event:{}", (Object)pluginTransactionStartEvent.getClass().getSimpleName());
        this.statsNumberStartEvents.getAndIncrement();
    }

    @EventListener
    public void onPluginTransactionStopEvent(PluginTransactionEndEvent pluginTransactionStopEvent) {
        if (log.isDebugEnabled()) {
            Object firstEvent = null;
            Object lastEvent = null;
            if (!pluginTransactionStopEvent.getEvents().isEmpty()) {
                firstEvent = pluginTransactionStopEvent.getEvents().iterator().next();
                lastEvent = pluginTransactionStopEvent.getEvents().reverse().iterator().next();
            }
            log.debug("[plugin-transaction] transaction ends with event:{}, numberEventsInTransaction:{}, firstEvent:{}, lastEvent:{}", new Object[]{pluginTransactionStopEvent.getClass().getSimpleName(), pluginTransactionStopEvent.numberOfEvents(), firstEvent, lastEvent});
        }
        this.statsNumberEndEvents.incrementAndGet();
        if (pluginTransactionStopEvent.numberOfEvents() > 0) {
            JiraPluginTransactionEndEvent jiraPluginTransactionEndEvent = new JiraPluginTransactionEndEvent(pluginTransactionStopEvent);
            this.statsNumberEventsInTransactions.addAndGet(jiraPluginTransactionEndEvent.numberOfEvents());
            this.replicationPauserManager.pauseReplicationFor(() -> {
                this.eventPublisher.publish((Object)jiraPluginTransactionEndEvent);
                this.statsNumberSendEvents.incrementAndGet();
            }, JiraPluginTransactionEndEvent.class.getSimpleName());
            if (log.isTraceEnabled()) {
                String eventsInTransactionLogged = jiraPluginTransactionEndEvent.getEvents().stream().map(o -> o.getClass().getSimpleName()).limit(1000L).collect(Collectors.joining(", "));
                String suffix = jiraPluginTransactionEndEvent.getEvents().size() <= 1000 ? "." : "... and more.";
                log.trace("[plugin-transaction] {} events in transaction: {}", (Object)jiraPluginTransactionEndEvent.numberOfEvents(), (Object)(eventsInTransactionLogged + suffix));
            }
        } else {
            log.trace("[plugin-transaction] Empty transaction.");
        }
    }
}

