/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.JiraHomeLocator;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.plugin.loaders.RosterFileScanner;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PluginPath {
    public static final String PLUGINS_DIRECTORY = "plugins";
    public static final String INSTALLED_PLUGINS_SUBDIR = PathUtils.joinPaths((String[])new String[]{"plugins", "installed-plugins"});
    public static final String FREEZE_FILE_PATH = PathUtils.joinPaths((String[])new String[]{"plugins", "installed-plugins-freeze.list"});
    public static final String OSGI_SUBDIR = PathUtils.joinPaths((String[])new String[]{"plugins", ".osgi-plugins"});
    public static final String BUNDLED_SUBDIR = PathUtils.joinPaths((String[])new String[]{"plugins", ".bundled-plugins"});

    public boolean isConfigured();

    public File getInstalledPluginsDirectory();

    public File getBundledPluginsDirectory();

    public File getCustomPluginsDirectory();

    public File getPluginsRosterFile();

    public File getPluginsFreezeFile();

    public OsgiPersistentCache getOsgiPersistentCache();

    public static class JiraHomeAdapter
    implements PluginPath {
        private final JiraHome jiraHome = new JiraHomeLocator.SystemJiraHome();
        private final File pluginsDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), "plugins");
        private final File localPluginsDirectory = this.createDirectoryIfNecessary(this.jiraHome.getLocalHome(), "plugins");
        private final File installedDirectory = this.createDirectoryIfNecessary(this.jiraHome.getHome(), INSTALLED_PLUGINS_SUBDIR);
        private final File bundledPluginsDirectory = this.createDirectoryIfNecessary(this.jiraHome.getLocalHome(), BUNDLED_SUBDIR);
        private final File customPluginsDirectory;
        private final File pluginsRosterFile;
        private final File freezeFile = new File(this.jiraHome.getHome(), FREEZE_FILE_PATH);
        private final OsgiPersistentCache osgiPersistentCache;
        private static final Logger log = LoggerFactory.getLogger(JiraHomeAdapter.class);

        public JiraHomeAdapter(JiraProperties jiraProperties) {
            if (jiraProperties.isCustomPathPluginsEnabled()) {
                File customPluginDirectoryCheck = new File(jiraProperties.getCustomDirectoryPlugins());
                if (customPluginDirectoryCheck.canRead() && customPluginDirectoryCheck.isDirectory()) {
                    this.customPluginsDirectory = customPluginDirectoryCheck;
                } else {
                    log.error("The Custom Plugin Directory path: " + customPluginDirectoryCheck.getAbsolutePath() + " does not exist or can not be read.");
                    this.customPluginsDirectory = null;
                }
            } else {
                this.customPluginsDirectory = null;
            }
            if (jiraProperties.isPluginsRosterFileEnabled()) {
                File pluginsRosterFileCheck = new File(jiraProperties.getPluginsRosterFile());
                if (RosterFileScanner.isKnownRosterFileFormat((File)pluginsRosterFileCheck)) {
                    this.pluginsRosterFile = pluginsRosterFileCheck;
                } else {
                    log.error("The Roster File path: '" + pluginsRosterFileCheck + "' is not a known format.");
                    this.pluginsRosterFile = null;
                }
            } else {
                this.pluginsRosterFile = null;
            }
            try {
                File osgiDirectory = this.createDirectoryIfNecessary(this.jiraHome.getLocalHome(), OSGI_SUBDIR);
                this.osgiPersistentCache = new DefaultOsgiPersistentCache(osgiDirectory);
            }
            catch (OsgiContainerException ex) {
                String message;
                Throwable cause = ex.getCause();
                if (cause != null && (message = cause.getMessage()) != null && message.startsWith("Unable to delete file: ")) {
                    File file = new File(message.substring("Unable to delete file: ".length()));
                    log.error(message + "  exists:" + file.exists() + "  canRead:" + file.canRead() + "  canWrite:" + file.canWrite() + "  isDirectory:" + file.isDirectory());
                }
                throw ex;
            }
        }

        @Override
        public boolean isConfigured() {
            try {
                this.jiraHome.getHomePath();
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }

        @Override
        public File getInstalledPluginsDirectory() {
            return this.installedDirectory;
        }

        @Override
        public File getBundledPluginsDirectory() {
            return this.bundledPluginsDirectory;
        }

        @Override
        public File getCustomPluginsDirectory() {
            return this.customPluginsDirectory;
        }

        @Override
        public File getPluginsRosterFile() {
            return this.pluginsRosterFile;
        }

        @Override
        public File getPluginsFreezeFile() {
            return this.freezeFile;
        }

        @Override
        public OsgiPersistentCache getOsgiPersistentCache() {
            return this.osgiPersistentCache;
        }

        private File createDirectoryIfNecessary(File root, String path) {
            File dir = new File(root, path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalStateException("Unable to create directory '" + dir + "'");
            }
            if (!dir.isDirectory()) {
                throw new IllegalStateException("File exists but is not a directory '" + dir + "'");
            }
            return dir;
        }
    }
}

