/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.PluginFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MasterPluginFactory
implements PluginFactory {
    private static final Logger log = LoggerFactory.getLogger(MasterPluginFactory.class);
    private final List<PluginFactory> pluginFactories;
    private final List<Pattern> pluginWhitelist;
    private final JiraFailedPluginTracker jiraFailedPluginTracker;
    private final Map<String, PluginFactory> factoryDecisions;

    public MasterPluginFactory(List<PluginFactory> pluginFactories, List<Pattern> pluginWhitelist, JiraFailedPluginTracker jiraFailedPluginTracker) {
        this.pluginFactories = pluginFactories;
        this.pluginWhitelist = pluginWhitelist;
        this.jiraFailedPluginTracker = jiraFailedPluginTracker;
        this.factoryDecisions = new HashMap<String, PluginFactory>();
    }

    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        log.debug("Seen plugin artifact '" + pluginArtifact.getName() + "'");
        if (!this.isInWhiteList(pluginArtifact)) {
            return null;
        }
        String canCreate = null;
        for (PluginFactory pluginFactory : this.pluginFactories) {
            canCreate = pluginFactory.canCreate(pluginArtifact);
            if (canCreate == null) continue;
            this.factoryDecisions.put(pluginArtifact.getName(), pluginFactory);
            break;
        }
        return canCreate;
    }

    private boolean isInWhiteList(PluginArtifact pluginArtifact) {
        for (Pattern allowedPattern : this.pluginWhitelist) {
            Matcher matcher = allowedPattern.matcher(pluginArtifact.getName());
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        PluginFactory pluginFactory = (PluginFactory)Assertions.notNull((String)"pluginFactory", (Object)this.factoryDecisions.get(pluginArtifact.getName()));
        Plugin plugin = pluginFactory.create(pluginArtifact, moduleDescriptorFactory);
        this.jiraFailedPluginTracker.trackLoadingPlugin(plugin, pluginArtifact);
        return plugin;
    }

    public ModuleDescriptor<?> createModule(Plugin plugin, Element moduleType, ModuleDescriptorFactory moduleDescriptorFactory) {
        for (PluginFactory pluginFactory : this.pluginFactories) {
            ModuleDescriptor moduleDescriptor = pluginFactory.createModule(plugin, moduleType, moduleDescriptorFactory);
            if (moduleDescriptor == null) continue;
            return moduleDescriptor;
        }
        return null;
    }
}

