/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginContainerFailedEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.exception.PluginExceptionInterception;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitEndedEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitStartingEvent;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class JiraFailedPluginTracker
implements PluginExceptionInterception,
InitializingComponent {
    private static final Function<Throwable, Option<List<String>>> CAPTURE_CAUSES = new Function<Throwable, Option<List<String>>>(){

        @Override
        public Option<List<String>> apply(Throwable input) {
            ArrayList causes = Lists.newArrayList((Object[])new String[]{input.getMessage()});
            int indent = 1;
            input = input.getCause();
            while (input != null) {
                causes.add(StringUtils.repeat((String)"\t", (int)indent) + input.getMessage());
                input = input.getCause();
                ++indent;
            }
            return Option.some((Object)causes);
        }
    };
    @ClusterSafe
    private final ConcurrentMap<String, PluginInfo> failedPlugins = new ConcurrentHashMap<String, PluginInfo>();
    @ClusterSafe
    private final ConcurrentMap<String, PluginInfo> trackedPlugins = new ConcurrentHashMap<String, PluginInfo>();
    private final PluginEventManager pluginEventManager;

    public JiraFailedPluginTracker(PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    public void trackLoadingPlugin(Plugin plugin, PluginArtifact pluginArtifact) {
        PluginInfo pluginInfo = new PluginInfo(plugin.getKey(), plugin.getName(), (Option<PluginArtifact>)Option.some((Object)pluginArtifact));
        this.trackedPlugins.put(plugin.getKey(), pluginInfo);
    }

    @PluginEventListener
    public void onPluginEnabledEvent(PluginEnabledEvent enabledEvent) {
        String key = enabledEvent.getPlugin().getKey();
        this.trackedPlugins.remove(key);
        this.failedPlugins.remove(key);
    }

    @PluginEventListener
    public void onPluginDisabledEvent(PluginDisabledEvent disabledEvent) {
        String key = disabledEvent.getPlugin().getKey();
        PluginInfo pluginInfo = (PluginInfo)this.trackedPlugins.get(key);
        if (pluginInfo != null) {
            pluginInfo = PluginInfo.addFailure(pluginInfo, "The plugin has been disabled.  A likely cause is that it timed out during initialisation");
            this.failedPlugins.put(key, pluginInfo);
        }
        this.trackedPlugins.remove(key);
    }

    @PluginEventListener
    public void onServiceDependencyWaitStarting(PluginServiceDependencyWaitStartingEvent event) {
        PluginInfo pluginInfo = (PluginInfo)this.trackedPlugins.get(event.getPluginKey());
        if (pluginInfo != null) {
            PluginInfo value = PluginInfo.addDependency(pluginInfo, event.getBeanName(), String.valueOf(event.getFilter()));
            this.trackedPlugins.put(event.getPluginKey(), value);
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitEnded(PluginServiceDependencyWaitEndedEvent event) {
        PluginInfo pluginInfo = (PluginInfo)this.trackedPlugins.get(event.getPluginKey());
        if (pluginInfo != null) {
            PluginInfo value = PluginInfo.removeDependency(pluginInfo, event.getBeanName());
            this.trackedPlugins.put(event.getPluginKey(), value);
        }
    }

    @PluginEventListener
    public void onPluginContainerFailed(PluginContainerFailedEvent event) throws IllegalPluginStateException {
        PluginInfo pluginInfo = (PluginInfo)this.trackedPlugins.get(event.getPluginKey());
        if (pluginInfo != null) {
            PluginInfo value = PluginInfo.addFailures(pluginInfo, event.getCause());
            this.failedPlugins.put(event.getPluginKey(), value);
        }
    }

    public boolean onEnableException(Plugin plugin, Exception pluginException) {
        PluginInfo pluginInfo = (PluginInfo)this.trackedPlugins.get(plugin.getKey());
        if (pluginInfo != null) {
            PluginInfo value = PluginInfo.addFailures(pluginInfo, pluginException);
            this.failedPlugins.put(plugin.getKey(), value);
        }
        return false;
    }

    public Iterable<PluginInfo> getFailedPlugins() {
        return Lists.newArrayList(this.failedPlugins.values());
    }

    public Iterable<PluginInfo> getUnaccountedForPlugins() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.trackedPlugins.values(), (Predicate)new Predicate<PluginInfo>(){

            public boolean apply(PluginInfo input) {
                return !JiraFailedPluginTracker.this.failedPlugins.containsKey(input.getPluginKey());
            }
        }));
    }

    public static class ServiceDependency {
        private final String serviceName;
        private final String serviceClass;

        public ServiceDependency(String serviceName, String serviceClass) {
            this.serviceName = serviceName;
            this.serviceClass = serviceClass;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDependency that = (ServiceDependency)o;
            return this.serviceName.equals(that.serviceName) && this.serviceClass.equals(that.serviceClass);
        }

        public int hashCode() {
            int result = this.serviceName.hashCode();
            result = 31 * result + this.serviceClass.hashCode();
            return result;
        }
    }

    public static class PluginInfo {
        private final String pluginKey;
        private final String pluginName;
        private final Option<PluginArtifact> pluginArtifact;
        private final Option<List<String>> failureCauses;
        private final List<ServiceDependency> dependencies;

        public static PluginInfo build(String pluginKey, String pluginClass, Option<PluginArtifact> pluginArtifact) {
            return new PluginInfo(pluginKey, pluginClass, pluginArtifact);
        }

        public static PluginInfo addFailures(PluginInfo pluginInfo, Throwable cause) {
            List<String> copiedCauses = PluginInfo.copyPreviousCauses(pluginInfo);
            Option capturedCauses = Option.option((Object)cause).flatMap(CAPTURE_CAUSES);
            if (capturedCauses.isDefined()) {
                copiedCauses.addAll((Collection)capturedCauses.get());
            }
            return new PluginInfo(pluginInfo.pluginKey, pluginInfo.pluginName, pluginInfo.pluginArtifact, (Option<List<String>>)Option.option(copiedCauses), pluginInfo.dependencies);
        }

        public static PluginInfo addFailure(PluginInfo pluginInfo, String cause) {
            List<String> copiedCauses = PluginInfo.copyPreviousCauses(pluginInfo);
            copiedCauses.add(cause);
            return new PluginInfo(pluginInfo.pluginKey, pluginInfo.pluginName, pluginInfo.pluginArtifact, (Option<List<String>>)Option.option(copiedCauses), pluginInfo.dependencies);
        }

        private static List<String> copyPreviousCauses(PluginInfo pluginInfo) {
            ArrayList copiedCauses = Lists.newArrayList();
            if (pluginInfo.getFailureCauses().isDefined()) {
                copiedCauses.addAll((Collection)pluginInfo.getFailureCauses().get());
            }
            return copiedCauses;
        }

        public static PluginInfo addDependency(PluginInfo pluginInfo, String serviceName, String serviceClass) {
            ArrayList deps = Lists.newArrayList(pluginInfo.getDependencies());
            deps.add(new ServiceDependency(serviceName, serviceClass));
            return new PluginInfo(pluginInfo, deps);
        }

        public static PluginInfo removeDependency(PluginInfo pluginInfo, final String serviceName) {
            Predicate<ServiceDependency> NOT_SERVICE_PREDICATE = new Predicate<ServiceDependency>(){

                public boolean apply(ServiceDependency input) {
                    return !input.getServiceName().equals(serviceName);
                }
            };
            ArrayList deps = Lists.newArrayList((Iterable)Iterables.filter(pluginInfo.getDependencies(), (Predicate)NOT_SERVICE_PREDICATE));
            return new PluginInfo(pluginInfo, deps);
        }

        PluginInfo(String pluginKey, String pluginName, Option<PluginArtifact> pluginArtifact) {
            this(pluginKey, pluginName, pluginArtifact, (Option<List<String>>)Option.none(), Collections.emptyList());
        }

        PluginInfo(PluginInfo copy, List<ServiceDependency> dependencies) {
            this(copy.pluginKey, copy.pluginName, copy.pluginArtifact, copy.failureCauses, dependencies);
        }

        PluginInfo(String pluginKey, String pluginName, Option<PluginArtifact> pluginArtifact, Option<List<String>> failureCauses, List<ServiceDependency> dependencies) {
            this.pluginKey = pluginKey;
            this.pluginName = pluginName;
            this.failureCauses = failureCauses;
            this.pluginArtifact = pluginArtifact;
            this.dependencies = dependencies;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public Option<PluginArtifact> getPluginArtifact() {
            return this.pluginArtifact;
        }

        public List<ServiceDependency> getDependencies() {
            return Lists.newArrayList(this.dependencies);
        }

        public Option<List<String>> getFailureCauses() {
            return this.failureCauses;
        }
    }
}

