/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.annotations.Internal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugin.JiraPluginTransactionEndEvent;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JiraCacheResetter {
    private static final Logger LOG = LoggerFactory.getLogger(JiraCacheResetter.class);
    private final Delegate delegate;

    public JiraCacheResetter(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager) {
        this.delegate = new Delegate(replicationPauserManager);
        eventPublisher.register((Object)this.delegate);
    }

    public static class Delegate {
        private volatile boolean jiraIsShuttingDown = false;
        private final ReplicationPauserManager replicationPauserManager;

        Delegate(ReplicationPauserManager replicationPauserManager) {
            this.replicationPauserManager = replicationPauserManager;
        }

        @EventListener
        public void onJiraPluginTransactionEndEvent(JiraPluginTransactionEndEvent event) {
            this.resetCachesAndLog(String.format("onJiraPluginTransactionEndEvent(%s)", event.numberOfEvents()));
        }

        private void resetCachesAndLog(String triggeredBy) {
            this.replicationPauserManager.pauseReplicationFor(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                LOG.debug("Start resetting caches triggered by: {}, jiraIsShuttingDown: {}", (Object)triggeredBy, (Object)this.jiraIsShuttingDown);
                this.resetCaches();
                LOG.debug("Done resetting caches triggered by: {}, timeMillis: {}, jiraIsShuttingDown: {}", new Object[]{triggeredBy, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), this.jiraIsShuttingDown});
            }, triggeredBy);
        }

        @EventListener
        public void onJiraShuttingDown(ComponentManagerShutdownEvent shutdownEvent) {
            this.jiraIsShuttingDown = true;
        }

        private void resetCaches() {
            PortletConfigurationStore store;
            FieldScreenManager screenManager;
            FieldManager fieldManager;
            if (this.jiraIsShuttingDown) {
                return;
            }
            CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
            if (customFieldManager != null) {
                customFieldManager.refresh();
            }
            if ((fieldManager = ComponentAccessor.getFieldManager()) != null) {
                fieldManager.refresh();
            }
            if ((screenManager = ComponentAccessor.getFieldScreenManager()) != null) {
                screenManager.refresh();
            }
            if ((store = (PortletConfigurationStore)ComponentAccessor.getComponent(PortletConfigurationStore.class)) instanceof FlushablePortletConfigurationStore) {
                ((FlushablePortletConfigurationStore)store).flush();
            }
            PropertyUtils.clearDescriptors();
        }
    }
}

