/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management.beans;

import com.atlassian.jira.permission.management.beans.ProjectPermissionHelpBean;
import com.atlassian.jira.permission.management.beans.SecurityTypeValueBean;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class SecurityTypeBean {
    private String securityType;
    private String displayName;
    private List<SecurityTypeValueBean> values;
    private ProjectPermissionHelpBean help;

    private SecurityTypeBean(String securityType, String displayName, Iterable<SecurityTypeValueBean> values, ProjectPermissionHelpBean help) {
        this.securityType = securityType;
        this.displayName = displayName;
        this.values = values != null ? ImmutableList.copyOf(values) : null;
        this.help = help;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<SecurityTypeValueBean> getValues() {
        return this.values;
    }

    public void setValues(List<SecurityTypeValueBean> values) {
        this.values = values != null ? ImmutableList.copyOf(values) : null;
    }

    public void setHelp(ProjectPermissionHelpBean help) {
        this.help = help;
    }

    public ProjectPermissionHelpBean getHelp() {
        return this.help;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecurityTypeBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityTypeBean that = (SecurityTypeBean)o;
        return Objects.equal((Object)this.securityType, (Object)that.securityType) && Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.securityType, this.displayName, this.values});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("securityType", (Object)this.securityType).add("displayName", (Object)this.displayName).add("values", this.values).add("help", (Object)this.help).toString();
    }

    public static final class Builder {
        private String securityType;
        private String displayName;
        private List<SecurityTypeValueBean> values = Lists.newArrayList();
        private ProjectPermissionHelpBean help;

        private Builder() {
        }

        private Builder(SecurityTypeBean initialData) {
            this.securityType = initialData.securityType;
            this.displayName = initialData.displayName;
            this.values = initialData.values;
        }

        public Builder setSecurityType(String securityType) {
            this.securityType = securityType;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setValues(List<SecurityTypeValueBean> values) {
            this.values = values;
            return this;
        }

        public Builder addValue(SecurityTypeValueBean value) {
            this.values.add(value);
            return this;
        }

        public Builder addValues(Iterable<SecurityTypeValueBean> values) {
            for (SecurityTypeValueBean value : values) {
                this.addValue(value);
            }
            return this;
        }

        public Builder setHelp(ProjectPermissionHelpBean help) {
            this.help = help;
            return this;
        }

        public SecurityTypeBean build() {
            return new SecurityTypeBean(this.securityType, this.displayName, this.values, this.help);
        }
    }
}

