/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management;

import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.notification.type.ProjectRoleSecurityAndNotificationType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.management.SecurityTypeValuesService;
import com.atlassian.jira.permission.management.beans.ProjectPermissionHelpBean;
import com.atlassian.jira.permission.management.beans.SecurityTypeBean;
import com.atlassian.jira.permission.management.beans.SecurityTypeValueBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.type.ApplicationRoleSecurityType;
import com.atlassian.jira.security.type.GroupCF;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.security.type.SecurityTypeKeys;
import com.atlassian.jira.security.type.UserCF;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SecurityTypeValuesServiceImpl
implements SecurityTypeValuesService {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionTypeManager permissionTypeManager;
    private final I18nHelper i18nHelper;
    private final HelpUrls urls;
    private static final ImmutableList<String> PRIMARY_SECURITY_TYPES = ImmutableList.of((Object)SecurityTypeKeys.PROJECT_ROLE.getKey(), (Object)SecurityTypeKeys.APPLICATION_ROLE.getKey(), (Object)SecurityTypeKeys.GROUP.getKey());

    public SecurityTypeValuesServiceImpl(GlobalPermissionManager globalPermissionManager, PermissionTypeManager permissionTypeManager, I18nHelper i18nHelper, HelpUrls helpUrls) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionTypeManager = permissionTypeManager;
        this.i18nHelper = i18nHelper;
        this.urls = helpUrls;
    }

    @Override
    public List<SecurityTypeBean> buildPrimarySecurityTypes(ApplicationUser user) {
        ArrayList<SecurityTypeBean> list = new ArrayList<SecurityTypeBean>();
        for (String securityTypeKey : PRIMARY_SECURITY_TYPES) {
            SecurityType securityType = (SecurityType)this.permissionTypeManager.getSchemeType(securityTypeKey);
            SecurityTypeBean securityTypeBean = this.makeSecurityTypeBean(user, securityTypeKey, securityType);
            list.add(securityTypeBean);
        }
        return list;
    }

    @Override
    public List<SecurityTypeBean> buildSecondarySecurityTypes(ApplicationUser user) {
        ArrayList<SecurityTypeBean> list = new ArrayList<SecurityTypeBean>();
        Map<String, SecurityType> securityTypes = this.permissionTypeManager.getSecurityTypes();
        for (Map.Entry<String, SecurityType> entry : securityTypes.entrySet()) {
            String securityTypeKey = entry.getKey();
            if (PRIMARY_SECURITY_TYPES.contains((Object)securityTypeKey)) continue;
            SecurityType securityType = (SecurityType)this.permissionTypeManager.getSchemeType(securityTypeKey);
            SecurityTypeBean securityTypeBean = this.makeSecurityTypeBean(user, securityTypeKey, securityType);
            list.add(securityTypeBean);
        }
        return list;
    }

    private ProjectPermissionHelpBean getSecurityHelp(ApplicationUser user, SecurityType securityType) {
        Boolean hasBrowseUsers;
        String securityTypeKey = securityType.getType();
        if (SecurityTypeKeys.USER.getKey().equals(securityTypeKey) && !(hasBrowseUsers = Boolean.valueOf(this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, user))).booleanValue()) {
            return new ProjectPermissionHelpBean(this.i18nHelper.getText("user.picker.no.permission.long"), this.i18nHelper.getText("user.picker.no.permission.help"), this.urls.getUrl("global_permissions").getUrl());
        }
        return null;
    }

    private List<SecurityTypeValueBean> getAddValues(SecurityType securityType) {
        String securityTypeKey = securityType.getType();
        if (SecurityTypeKeys.PROJECT_ROLE.getKey().equals(securityTypeKey)) {
            return this.buildProjectRoles((ProjectRoleSecurityAndNotificationType)securityType);
        }
        if (SecurityTypeKeys.APPLICATION_ROLE.getKey().equals(securityTypeKey)) {
            return this.buildApplicationRoleSecurityType((ApplicationRoleSecurityType)securityType);
        }
        if (SecurityTypeKeys.USER_CF.getKey().equals(securityTypeKey)) {
            return this.buildUserCFs((UserCF)securityType);
        }
        if (SecurityTypeKeys.GROUP_CF.getKey().equals(securityTypeKey)) {
            return this.buildGroupCFs((GroupCF)securityType);
        }
        return Collections.emptyList();
    }

    private SecurityTypeBean makeSecurityTypeBean(ApplicationUser user, String type, SecurityType securityType) {
        return SecurityTypeBean.builder().setSecurityType(type).setDisplayName(securityType.getDisplayName()).setValues(this.getAddValues(securityType)).setHelp(this.getSecurityHelp(user, securityType)).build();
    }

    private List<SecurityTypeValueBean> buildApplicationRoleSecurityType(ApplicationRoleSecurityType securityType) {
        Set<ApplicationRole> applicationRoles = securityType.getApplicationRoles();
        return Lists.newArrayList((Iterable)Iterables.transform(applicationRoles, role -> SecurityTypeValueBean.builder().setValue(role.getKey().value()).setDisplayValue(role.getName()).build()));
    }

    private List<SecurityTypeValueBean> buildGroupCFs(GroupCF securityType) {
        List<Field> fields = securityType.getDisplayFields();
        return this.buildFromFields(fields);
    }

    private List<SecurityTypeValueBean> buildUserCFs(UserCF securityType) {
        List<Field> fields = securityType.getDisplayFields();
        return this.buildFromFields(fields);
    }

    private List<SecurityTypeValueBean> buildFromFields(Collection<Field> fields) {
        return Lists.newArrayList((Iterable)Iterables.transform(fields, field -> SecurityTypeValueBean.builder().setValue(String.valueOf(field.getId())).setDisplayValue(field.getName()).build()));
    }

    private List<SecurityTypeValueBean> buildProjectRoles(ProjectRoleSecurityAndNotificationType securityType) {
        Collection<ProjectRole> projectRoles = securityType.getProjectRoles();
        return Lists.newArrayList((Iterable)Iterables.transform(projectRoles, projectRole -> SecurityTypeValueBean.builder().setValue(String.valueOf(projectRole.getId())).setDisplayValue(projectRole.getName()).build()));
    }

    @Override
    public void sort(List<SecurityTypeBean> grants) {
        final Comparator primaryComparator = (o1, o2) -> {
            int i1 = PRIMARY_SECURITY_TYPES.indexOf(o1);
            int i2 = PRIMARY_SECURITY_TYPES.indexOf(o2);
            return i1 - i2;
        };
        Collections.sort(grants, new Comparator<SecurityTypeBean>(){

            @Override
            public int compare(SecurityTypeBean o1, SecurityTypeBean o2) {
                String securityType1 = o1.getSecurityType();
                String securityType2 = o2.getSecurityType();
                if (PRIMARY_SECURITY_TYPES.contains((Object)securityType1) && PRIMARY_SECURITY_TYPES.contains((Object)securityType2)) {
                    return primaryComparator.compare(securityType1, securityType2);
                }
                if (PRIMARY_SECURITY_TYPES.contains((Object)securityType1) && !PRIMARY_SECURITY_TYPES.contains((Object)securityType2)) {
                    return -1;
                }
                if (!PRIMARY_SECURITY_TYPES.contains((Object)securityType1) && PRIMARY_SECURITY_TYPES.contains((Object)securityType2)) {
                    return 1;
                }
                return securityType1.compareTo(securityType2);
            }
        });
    }
}

