/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DefaultProjectPermissionSchemeHelper
implements ProjectPermissionSchemeHelper {
    private final PermissionSchemeManager permissionSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public DefaultProjectPermissionSchemeHelper(PermissionSchemeManager permissionSchemeManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<Project> getSharedProjects(Scheme permissionScheme) {
        ArrayList sharedProjects = Lists.newArrayList();
        for (Project project : this.getAllSharedProjects(permissionScheme)) {
            if (!this.hasEditPermission(this.authenticationContext.getUser(), project)) continue;
            sharedProjects.add(project);
        }
        sharedProjects.sort(ProjectNameComparator.COMPARATOR);
        return sharedProjects;
    }

    @Override
    public int getAllSharedProjectsCount(Scheme permissionScheme) {
        return this.getAllSharedProjects(permissionScheme).size();
    }

    private List<Project> getAllSharedProjects(Scheme permissionScheme) {
        return this.permissionSchemeManager.getProjects(permissionScheme);
    }

    boolean hasEditPermission(ApplicationUser user, Project project) {
        return ProjectAction.VIEW_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }
}

