/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.model.querydsl.PermissionSchemeAttributeDTO;
import com.atlassian.jira.model.querydsl.QPermissionSchemeAttribute;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@EventComponent
@ParametersAreNonnullByDefault
public class DefaultPermissionSchemeAttributeManager
implements PermissionSchemeAttributeManager {
    private static final QPermissionSchemeAttribute ATTRIBUTE = QPermissionSchemeAttribute.PERMISSION_SCHEME_ATTRIBUTE;
    private static final String PERMISSION_SCHEME_ATTRIBUTE_CACHE_NAME = DefaultPermissionSchemeAttributeManager.class.getName() + ".schemeIdToAttributes";
    private final QueryDslAccessor queryDslAccessor;
    private final Cache<Long, Map<String, String>> cache;

    public DefaultPermissionSchemeAttributeManager(QueryDslAccessor queryDslAccessor, CacheManager cacheManager) {
        this.queryDslAccessor = queryDslAccessor;
        this.cache = cacheManager.getCache(PERMISSION_SCHEME_ATTRIBUTE_CACHE_NAME, this::getAttributesWithDefaults);
    }

    public Map<String, String> getAttributes(Long schemeId) {
        return (Map)this.cache.get((Object)schemeId);
    }

    public Optional<String> getAttribute(Long schemeId, String key) {
        Map<String, String> attributes = this.getAttributes(schemeId);
        if (!attributes.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(attributes.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Long schemeId, String key, String value) {
        try {
            this.queryDslAccessor.execute(dbConnection -> {
                if (this.updateAttributeImpl(dbConnection, schemeId, key, value) <= 0L) {
                    this.insertAttributeImpl(dbConnection, schemeId, key, value);
                }
            });
        }
        finally {
            this.cache.remove((Object)schemeId);
        }
    }

    public void updateAttributes(Long schemeId, Map<String, String> attributes) {
        try {
            this.queryDslAccessor.execute(dbConnection -> {
                Map<String, String> existing = this.selectAttributesImpl(schemeId);
                MapDifference diff = Maps.difference(existing, (Map)attributes);
                Map newAttributes = diff.entriesOnlyOnRight();
                Map removedAttributes = diff.entriesOnlyOnLeft();
                Map changedAttributes = Maps.transformValues((Map)diff.entriesDiffering(), MapDifference.ValueDifference::rightValue);
                this.insertAttributesImpl(dbConnection, schemeId, newAttributes);
                this.updateAttributesImpl(dbConnection, schemeId, changedAttributes);
                this.deleteAttributesImpl(dbConnection, schemeId, removedAttributes.keySet());
            });
        }
        finally {
            this.cache.remove((Object)schemeId);
        }
    }

    public void deleteAttributes(Long schemeId, Collection<String> keys) {
        try {
            this.queryDslAccessor.execute(dbConnection -> this.deleteAttributesImpl(dbConnection, schemeId, keys));
        }
        finally {
            this.cache.remove((Object)schemeId);
        }
    }

    public void clearAttributes(Long schemeId) {
        try {
            this.queryDslAccessor.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)ATTRIBUTE).where((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.scheme.eq((Object)schemeId)).execute());
        }
        finally {
            this.cache.remove((Object)schemeId);
        }
    }

    public Map<String, String> getDefaultAttributes() {
        return ImmutableMap.of((Object)"ADMINISTER_PROJECTS.extended.enabled", (Object)"true");
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    private void insertAttributesImpl(DbConnection dbConnection, Long schemeId, Map<String, String> newAttributes) {
        newAttributes.forEach((key, value) -> this.insertAttributeImpl(dbConnection, schemeId, (String)key, (String)value));
    }

    private void updateAttributesImpl(DbConnection dbConnection, Long schemeId, Map<String, String> changedAttributes) {
        changedAttributes.forEach((key, value) -> this.updateAttributeImpl(dbConnection, schemeId, (String)key, (String)value));
    }

    private long deleteAttributesImpl(DbConnection dbConnection, Long schemeId, Collection<String> keys) {
        if (keys.isEmpty()) {
            return -1L;
        }
        return dbConnection.delete((RelationalPath<?>)ATTRIBUTE).where((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.scheme.eq((Object)schemeId).and((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.attributeKey.in(keys))).execute();
    }

    private long insertAttributeImpl(DbConnection dbConnection, Long schemeId, String key, String value) {
        return dbConnection.insert(ATTRIBUTE).withId().set((Path)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.scheme, schemeId).set((Path)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.attributeKey, key).set((Path)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.attributeValue, value).execute();
    }

    private long updateAttributeImpl(DbConnection dbConnection, Long schemeId, String key, String value) {
        return dbConnection.update((RelationalPath<?>)ATTRIBUTE).where((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.scheme.eq((Object)schemeId).and((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.attributeKey.eq((Object)key))).set((Path)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.attributeValue, (Object)value).execute();
    }

    private Map<String, String> selectAttributesImpl(Long schemeId) {
        return this.asMap(this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)ATTRIBUTE).from((Expression)ATTRIBUTE)).where((Predicate)DefaultPermissionSchemeAttributeManager.ATTRIBUTE.scheme.eq((Object)schemeId))).fetch()));
    }

    private Map<String, String> getAttributesWithDefaults(Long schemeId) {
        Map<String, String> attributes = this.selectAttributesImpl(schemeId);
        this.getDefaultAttributes().forEach(attributes::putIfAbsent);
        return attributes;
    }

    private Map<String, String> asMap(List<PermissionSchemeAttributeDTO> list) {
        return list.stream().collect(Collectors.toMap(PermissionSchemeAttributeDTO::getAttributeKey, PermissionSchemeAttributeDTO::getAttributeValue));
    }
}

