/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.util.BytesRef;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRoleSecurityAndNotificationType
extends AbstractProjectsSecurityType
implements NotificationType,
SecurityType {
    public static final String PROJECT_ROLE = "projectrole";
    private static final Logger log = LoggerFactory.getLogger(ProjectRoleSecurityAndNotificationType.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectFactory projectFactory;

    public ProjectRoleSecurityAndNotificationType(JiraAuthenticationContext jiraAuthenticationContext, ProjectRoleManager projectRoleManager, ProjectFactory projectFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRoleManager = projectRoleManager;
        this.projectFactory = projectFactory;
    }

    @Override
    public boolean isTopLevelIssueSecurityPermission() {
        return false;
    }

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        return ImmutableSet.of((Object)SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)securityLevel.getId(), (Long)project.getId()));
    }

    public Collection<ProjectRole> getProjectRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notifications.projectrole");
    }

    @Override
    public String getType() {
        return PROJECT_ROLE;
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        if (!this.doValidation(key, parameters)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.project.role");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        }
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        if (StringUtils.isNotBlank((CharSequence)((String)value)) && NumberUtils.isNumber((String)value.toString())) {
            Long roleId = Long.valueOf(value.toString());
            for (ProjectRole projectRole : this.getProjectRoles()) {
                if (!roleId.equals(projectRole.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getArgumentDisplay(String roleTypeId) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(new Long(roleTypeId));
        return projectRole.getName();
    }

    @Override
    public String getArgumentValue(String roleTypeId) {
        return roleTypeId;
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext permissionContext, String roleId) {
        GenericValue projectGv = permissionContext.getProject();
        if (projectGv != null) {
            Project project = this.projectFactory.getProject(projectGv);
            return this.getUsersFromRole(project, roleId);
        }
        log.warn("returning no users because project in the permission context was null");
        return Collections.emptySet();
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument, ApplicationUser user, boolean issueCreation) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null");
        }
        ProjectRoleActors projectRoleActors = this.getProjectRoleActors(argument, project);
        return projectRoleActors.contains(user);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(issue.getProjectObject(), parameter, user, issueCreation);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String roleId) {
        Project project = event.getIssue().getProjectObject();
        if (project == null) {
            return Collections.emptyList();
        }
        Set<ApplicationUser> recipients = this.getUsersFromRole(project, roleId);
        ArrayList<NotificationRecipient> notificationRecipients = new ArrayList<NotificationRecipient>(recipients.size());
        for (ApplicationUser user : recipients) {
            notificationRecipients.add(new NotificationRecipient(user));
        }
        return notificationRecipients;
    }

    @VisibleForTesting
    protected Set<ApplicationUser> getUsersFromRole(Project project, String roleId) {
        try {
            ProjectRoleActors projectRoleActors = this.getProjectRoleActors(roleId, project);
            return projectRoleActors.getUsers();
        }
        catch (IllegalArgumentException e) {
            log.error("Could not resolve project role actors for the provided roleId and project", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private ProjectRoleActors getProjectRoleActors(String roleId, Project project) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(new Long(roleId));
        return this.projectRoleManager.getProjectRoleActors(projectRole, project);
    }
}

