/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.cache.CacheManager;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.notification.NotificationAddedEvent;
import com.atlassian.jira.event.notification.NotificationDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeAddedToProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCopiedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCreatedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNotificationSchemeManager
extends AbstractSchemeManager
implements NotificationSchemeManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationSchemeManager.class);
    private static final String SCHEME_ENTITY_NAME = "NotificationScheme";
    private static final String NOTIFICATION_ENTITY_NAME = "Notification";
    private static final String SCHEME_DESC = "Notification";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.notifications.default";
    private static final long DEFAULT_NOTIFICATION_SCHEME_ID = 10000L;
    private final OfBizDelegator delegator;
    private final NotificationTypeManager notificationTypeManager;
    private final UserPreferencesManager userPreferencesManager;

    public DefaultNotificationSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, EventPublisher eventPublisher, NotificationTypeManager notificationTypeManager, NodeAssociationStore nodeAssociationStore, GroupManager groupManager, UserPreferencesManager userPreferencesManager, CacheManager cacheManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, delegator, groupManager, eventPublisher, cacheManager);
        this.delegator = delegator;
        this.notificationTypeManager = notificationTypeManager;
        this.userPreferencesManager = userPreferencesManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return "Notification";
    }

    @Override
    public String getSchemeDesc() {
        return "Notification";
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return null;
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new NotificationSchemeCreatedEvent(scheme);
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new NotificationSchemeCopiedEvent(oldScheme, newScheme);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new NotificationSchemeUpdatedEvent(scheme, originalScheme);
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        Scheme scheme = this.getSchemeObject(id);
        super.deleteScheme(id);
        this.eventPublisher.publish((Object)new NotificationSchemeDeletedEvent(id, scheme.getName()));
    }

    @Override
    @Nonnull
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new NotificationSchemeAddedToProjectEvent(scheme, project);
    }

    @Override
    public GenericValue getDefaultScheme() throws GenericEntityException {
        return this.getScheme(10000L);
    }

    @Override
    public GenericValue createDefaultScheme() throws GenericEntityException {
        if (this.getDefaultScheme() == null) {
            String name = this.getApplicationI18n().getText(DEFAULT_NAME_KEY);
            GenericValue defaultScheme = DEFAULT_NAME_KEY.equals(name) ? this.createSchemeGenericValue((Map<String, Object>)FieldMap.build((String)"name", (Object)"Default Notification Scheme", (String)"description", null)) : this.createSchemeGenericValue((Map<String, Object>)FieldMap.build((String)"name", (Object)name, (String)"description", null));
            return defaultScheme;
        }
        return this.getDefaultScheme();
    }

    public void removeSchemeEntitiesForField(String customFieldId) throws RemoveException {
        this.removeEntities("User_Custom_Field_Value", customFieldId);
        this.removeEntities("Group_Custom_Field_Value", customFieldId);
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue schemeEntityGV) {
        return new SchemeEntity(schemeEntityGV.getLong("id"), schemeEntityGV.getString("type"), schemeEntityGV.getString("parameter"), schemeEntityGV.get("eventTypeId"), schemeEntityGV.get("templateId"), schemeEntityGV.getLong("scheme"));
    }

    @Override
    protected Object createSchemeEntityDeletedEvent(GenericValue entity) {
        return new NotificationDeletedEvent(entity.getLong("scheme"), this.makeSchemeEntity(entity));
    }

    public List<SchemeEntity> getNotificationSchemeEntities(Project project, long entityTypeId) throws GenericEntityException {
        GenericValue notificationScheme = this.getNotificationSchemeForProject(project.getGenericValue());
        if (notificationScheme == null) {
            return Collections.emptyList();
        }
        return this.getEntities(notificationScheme, entityTypeId).stream().map(this::makeSchemeEntity).collect(Collectors.toList());
    }

    public GenericValue getNotificationSchemeForProject(GenericValue projectGV) {
        block3: {
            try {
                List<GenericValue> notificationSchemes = this.getSchemes(projectGV);
                if (notificationSchemes == null || notificationSchemes.isEmpty()) break block3;
                if (notificationSchemes.size() > 1) {
                    log.error("There are multiple notification schemes associated with the project: " + projectGV.getString("name") + ". No emails will be sent for issue events in this project.");
                    break block3;
                }
                return notificationSchemes.get(0);
            }
            catch (GenericEntityException e) {
                log.error("There was an error retrieving the notification schemes for the project: " + projectGV.getString("name") + ". No emails will be sent for issue events in this project.", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Map<Long, String> getSchemesMapByConditions(Map<String, ?> conditions) {
        LinkedHashMap<Long, String> schemeMap = new LinkedHashMap<Long, String>();
        try (OfBizListIterator listIterator = null;){
            EntityFindOptions entityFindOptions = new EntityFindOptions();
            entityFindOptions.setDistinct(true);
            listIterator = this.delegator.findListIteratorByCondition("Notification", (EntityCondition)new EntityFieldMap(conditions, EntityOperator.AND), null, null, null, entityFindOptions);
            GenericValue resultMap = listIterator.next();
            while (resultMap != null) {
                Long schemeId = resultMap.getLong("scheme");
                if (schemeId != null) {
                    Scheme notificationScheme = this.getSchemeObject(schemeId);
                    schemeMap.put(schemeId, notificationScheme.getName());
                }
                resultMap = listIterator.next();
            }
        }
        return schemeMap;
    }

    @Nonnull
    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        Map conditions = EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter);
        List entities = this.delegator.findByAnd("Notification", conditions);
        List entityConditions = entities.stream().map(schemeEntity -> schemeEntity.getLong("scheme")).distinct().map(id -> new EntityExpr("id", EntityOperator.EQUALS, id)).collect(Collectors.toList());
        if (entityConditions.isEmpty()) {
            return Collections.emptyList();
        }
        return this.delegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList());
    }

    public boolean isHasMailServer() throws MailException {
        try {
            SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
            return smtp != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        GenericValue result = this.createSchemeEntityNoEvent(scheme, schemeEntity);
        this.eventPublisher.publish((Object)new NotificationAddedEvent(scheme.getLong("id"), schemeEntity));
        return result;
    }

    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Notification scheme IDs must be Long values.");
        }
        return EntityUtils.createValue(this.getEntityName(), EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"eventTypeId", (Object)schemeEntity.getEntityTypeId(), (Object)"type", (Object)schemeEntity.getType(), (Object)"parameter", (Object)schemeEntity.getParameter(), (Object)"templateId", (Object)schemeEntity.getTemplateId()));
    }

    public Set<NotificationRecipient> getRecipients(IssueEvent event, SchemeEntity notification) throws GenericEntityException {
        ExtendedPreferences userPreference;
        HashSet<NotificationRecipient> recipients = new HashSet<NotificationRecipient>();
        NotificationType notificationType = this.notificationTypeManager.getNotificationType(notification.getType());
        List<NotificationRecipient> possibleRecipients = notificationType.getRecipients(event, notification.getParameter());
        for (NotificationRecipient recipient : possibleRecipients) {
            ApplicationUser userRecipient = recipient.getUserRecipient();
            if (userRecipient != null && !userRecipient.isActive()) continue;
            recipients.add(recipient);
        }
        ApplicationUser user = event.getUser();
        if (user != null && !(userPreference = this.userPreferencesManager.getExtendedPreferences(user)).getBoolean("user.notify.own.changes")) {
            recipients.remove(new NotificationRecipient(user));
            if (log.isDebugEnabled()) {
                log.debug("Removed user " + user.getDisplayName() + " with email address " + user.getEmailAddress() + " from notification because they are the modifier and do not wish to be notified.");
            }
        }
        return recipients;
    }

    public Set<NotificationRecipient> getRecipients(IssueEvent event) {
        Assertions.notNull((String)"issueEvent", (Object)event);
        LinkedHashSet<NotificationRecipient> ret = new LinkedHashSet<NotificationRecipient>();
        try {
            List<SchemeEntity> schemeEntities = this.getNotificationSchemeEntities(event.getProject(), event.getEventTypeId());
            for (SchemeEntity schemeEntity : schemeEntities) {
                ret.addAll(this.getRecipients(event, schemeEntity));
            }
        }
        catch (GenericEntityException e) {
            log.error("There was an error accessing the notification scheme for the project: " + event.getProject() + '.', (Throwable)e);
        }
        return ret;
    }

    public boolean hasEntities(GenericValue scheme, Long eventTypeId, String type, String parameter, Long templateId) throws GenericEntityException {
        List entity = scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId, (Object)"type", (Object)type, (Object)"parameter", (Object)parameter, (Object)"templateId", (Object)templateId));
        return entity != null && !entity.isEmpty();
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Notification scheme event type IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long eventTypeId) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long eventTypeId, String parameter) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)entityTypeId, (Object)"type", (Object)type));
    }

    @Override
    @Nonnull
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new NotificationSchemeRemovedFromProjectEvent(scheme, project);
    }

    @Override
    protected I18nHelper getApplicationI18n() {
        return new I18nBean((ApplicationUser)null);
    }
}

