/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.monitoring.jmx;

import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.InstrumentRegistry;
import com.atlassian.instrumentation.operations.OpCounter;
import com.atlassian.jira.instrumentation.GenericInstrument;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.monitoring.jmx.bean.DynamicJmxValue;
import com.atlassian.jira.monitoring.jmx.bean.JmxMBean;
import com.atlassian.jira.monitoring.jmx.bean.JmxValue;
import com.atlassian.jira.util.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.Attribute;

public class InstrumentationMetricsCollector {
    private static final Set<InstrumentationName> EXPOSED_STATIC_METRICS = ImmutableSet.of((Object)((Object)InstrumentationName.TOTAL_ISSUES), (Object)((Object)InstrumentationName.WORKFLOW_AUTOMATIC_TRANSITION), (Object)((Object)InstrumentationName.WORKFLOW_MANUAL_TRANSITION), (Object)((Object)InstrumentationName.TOTAL_CUSTOMFIELDS), (Object)((Object)InstrumentationName.TOTAL_USERS), (Object)((Object)InstrumentationName.TOTAL_GROUPS), (Object[])new InstrumentationName[]{InstrumentationName.WEB_REQUESTS, InstrumentationName.TOTAL_VERSIONS, InstrumentationName.TOTAL_COMPONENTS, InstrumentationName.TOTAL_ATTACHMENTS, InstrumentationName.ISSUE_CREATED_COUNT, InstrumentationName.ISSUE_UPDATED_COUNT, InstrumentationName.ISSUE_ASSIGNED_COUNT, InstrumentationName.ISSUE_WORKLOGGED_COUNT, InstrumentationName.ISSUE_LINK_CREATED_COUNT, InstrumentationName.ISSUE_SEARCH_COUNT, InstrumentationName.DASHBOARD_VIEW_COUNT, InstrumentationName.LICENSE_INFO, InstrumentationName.TOTAL_FILTERS, InstrumentationName.QUICKSEARCH_CONCURRENT_REQUESTS, InstrumentationName.DB_READS, InstrumentationName.DB_WRITES, InstrumentationName.DB_CONNECTIONS, InstrumentationName.DB_CONNECTIONS_BORROWED, InstrumentationName.DB_CONNECTIONS_TIME_TO_BORROW, InstrumentationName.HTTP_SESSIONS, InstrumentationName.CONCURRENT_REQUESTS});
    private final InstrumentRegistry instrumentRegistry;

    public InstrumentationMetricsCollector(InstrumentRegistry instrumentRegistry) {
        this.instrumentRegistry = instrumentRegistry;
    }

    public Collection<JmxMBean> collect() {
        ArrayList<JmxMBean> metrics = new ArrayList<JmxMBean>();
        for (InstrumentationName exposedMetric : EXPOSED_STATIC_METRICS) {
            Instrument instrument = this.instrumentRegistry.getInstrument(exposedMetric.getInstrumentName());
            if (instrument == null) continue;
            if (instrument instanceof GenericInstrument) {
                metrics.add(this.newDynamicJmxValue((GenericInstrument)instrument));
                continue;
            }
            if (instrument instanceof OpCounter) {
                metrics.add(this.newDynamicJmxValue((OpCounter)instrument));
                continue;
            }
            metrics.add(this.newJmxValue(instrument));
        }
        return metrics;
    }

    private JmxValue<Long> newJmxValue(Instrument instrument) {
        return new JmxValue<Long>(instrument.getName(), () -> ((Instrument)instrument).getValue());
    }

    private DynamicJmxValue newDynamicJmxValue(GenericInstrument genericInstrument) {
        return new DynamicJmxValue(genericInstrument.getName(), genericInstrument.snapshot().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> () -> new Attribute((String)e.getKey(), ((Supplier)e.getValue()).get()))));
    }

    private DynamicJmxValue newDynamicJmxValue(OpCounter opCounter) {
        HashMap<String, Supplier<Attribute>> attributeMap = new HashMap<String, Supplier<Attribute>>();
        attributeMap.put("invocation.count", () -> new Attribute("invocation.count", opCounter.snapshot().getInvocationCount()));
        attributeMap.put("total.elapsed.time", () -> new Attribute("total.elapsed.time", opCounter.snapshot().getMillisecondsTaken()));
        return new DynamicJmxValue(opCounter.getName(), attributeMap);
    }
}

