/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.memoryinspector;

import com.atlassian.jira.memoryinspector.InspectionReport;
import com.atlassian.jira.memoryinspector.ThreadInfo;
import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.log4j.Logger;

public class ThreadsInspectionReport
implements InspectionReport {
    private final List<ThreadInfo> unexpectedThreads;

    public ThreadsInspectionReport(List<ThreadInfo> unexpectedThreads) {
        this.unexpectedThreads = unexpectedThreads;
    }

    @Override
    public void printReport(Logger log) {
        for (ThreadInfo threadInfo : this.unexpectedThreads) {
            log.warn((Object)"Unexpected thread found, this probably will cause memory leaks and can result in OutOfMemoryError!");
            this.printThreadInfo(threadInfo, log);
        }
    }

    public List<ThreadInfo> getUnexpectedThreads() {
        return this.unexpectedThreads;
    }

    @Override
    public boolean inspectionPassed() {
        return this.unexpectedThreads.isEmpty();
    }

    private void printThreadInfo(ThreadInfo threadInfo, Logger log) {
        BundleImpl bundle;
        log.warn((Object)String.format("********* Thread #%d %s [%s] *********", threadInfo.getThread().getId(), threadInfo.getThreadName(), threadInfo.getThreadGroupName()));
        log.warn((Object)String.format(" threadInfo: %s", threadInfo));
        log.warn((Object)String.format(" state: %s", new Object[]{threadInfo.getThread().getState()}));
        log.warn((Object)String.format(" priority: %d", threadInfo.getThread().getPriority()));
        log.warn((Object)String.format(" class: %s", threadInfo.getThreadClassName()));
        ClassLoader contextClassLoader = threadInfo.getThread().getContextClassLoader();
        log.warn((Object)String.format(" contextClassLoader: %s", contextClassLoader));
        if (contextClassLoader instanceof BundleWiringImpl.BundleClassLoader && (bundle = ((BundleWiringImpl.BundleClassLoader)contextClassLoader).getBundle()) != null) {
            log.warn((Object)String.format(" contextClassLoader.bundle: %s", bundle.getSymbolicName()));
        }
        log.warn((Object)String.format("", new Object[0]));
        log.warn((Object)String.format("Thread stack trace:", new Object[0]));
        for (StackTraceElement stackTraceElement : threadInfo.getThread().getStackTrace()) {
            log.warn((Object)String.format("\tat " + stackTraceElement, new Object[0]));
        }
        log.warn((Object)String.format(".", new Object[0]));
    }
}

