/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarManagerImpl;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.mail.TemplateUser;
import com.atlassian.jira.mail.util.MailAttachment;
import com.atlassian.jira.mail.util.MailAttachments;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttachmentsManagerImpl
implements MailAttachmentsManager {
    private static final Logger log = LoggerFactory.getLogger(MailAttachmentsManagerImpl.class);
    private static final Pattern IMG_TAG_WITH_SRC_PATTERN = Pattern.compile("(<img .*?src *= *['\"]?)([^\\s'\">]*)(['\"]?.*?>)");
    private final AvatarService avatarService;
    private final AvatarTranscoder avatarTranscoder;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final ApplicationProperties applicationProperties;
    @ClusterSafe(value="This is a local object used in the creation of a single email")
    private final Map<MailAttachment, String> mailAttachments = Collections.synchronizedMap(Maps.newHashMap());

    public MailAttachmentsManagerImpl(AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager, ApplicationProperties applicationProperties) {
        this.avatarService = avatarService;
        this.avatarTranscoder = avatarTranscoder;
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getAvatarUrl(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        return this.getAvatarUrl(user);
    }

    @Override
    public String getAvatarUrl(TemplateUser templateUser) {
        return this.getAvatarUrl(templateUser.getName());
    }

    @Override
    public String getAvatarUrl(ApplicationUser user) {
        if (user != null && this.avatarService.isUsingExternalAvatar(this.getLoggedInUser(), user)) {
            return this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.defaultSize()).toString();
        }
        return this.addAttachmentAndReturnCid(this.createUserAvatarAttachment(user));
    }

    @Override
    public String getAvatarUrl(@Nonnull Avatar avatar, @Nonnull Avatar.Size size, String avatarOwnerDescription) {
        Objects.requireNonNull(size);
        return this.addAttachmentAndReturnCid(this.createAvatarAttachment(avatar, size, avatarOwnerDescription));
    }

    public String getIssueTypeIconUrl(IssueType issueType) {
        return issueType.getAvatar() == null ? this.getImageUrl(issueType.getIconUrlHtml()) : this.addAttachmentAndReturnCid(this.createAvatarAttachment(issueType.getAvatar(), Avatar.Size.MEDIUM, "issue type: " + issueType.getName()));
    }

    private ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
    }

    @Override
    public String addAttachmentAndReturnCid(MailAttachment mailAttachment) {
        if (this.mailAttachments.containsKey(mailAttachment)) {
            return this.buildCidUrl(this.mailAttachments.get(mailAttachment));
        }
        String cid = this.generateCid(mailAttachment);
        if (this.mailAttachments.containsValue(cid)) {
            cid = cid + UUID.randomUUID().toString();
        }
        this.mailAttachments.put(mailAttachment, cid);
        return this.buildCidUrl(cid);
    }

    private String buildCidUrl(String cid) {
        return "cid:" + cid;
    }

    private String generateCid(MailAttachment attachment) {
        return "jira-generated-image-" + attachment.getUniqueName();
    }

    @Override
    public String getImageUrl(String path) {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        try {
            if (servletContext.getResource(path) == null) {
                return this.getAbsoluteUrl(path);
            }
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return this.getAbsoluteUrl(path);
        }
        return this.addAttachmentAndReturnCid(MailAttachments.newImageAttachment(path, this.avatarTranscoder));
    }

    @Override
    public String inlineImages(String html) {
        Matcher matcher = IMG_TAG_WITH_SRC_PATTERN.matcher(html);
        StringBuilder htmlWithInlineImages = new StringBuilder(html.length());
        int lastMatch = 0;
        while (matcher.find()) {
            htmlWithInlineImages.append(html, lastMatch, matcher.start());
            htmlWithInlineImages.append(matcher.group(1));
            String inlinedImage = this.getImageUrl(this.removeBaseUrl(matcher.group(2)));
            if (inlinedImage.startsWith("cid:")) {
                htmlWithInlineImages.append(inlinedImage);
            } else {
                htmlWithInlineImages.append(matcher.group(2));
            }
            htmlWithInlineImages.append(matcher.group(3));
            lastMatch = matcher.end();
        }
        htmlWithInlineImages.append(html, lastMatch, html.length());
        return htmlWithInlineImages.toString();
    }

    @Override
    public String removeBaseUrl(String url) {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        String basePath = this.getBasePath();
        String urlWithRemovedBaseUrl = StringUtils.removeStart((String)url, (String)baseUrl);
        return StringUtils.removeStart((String)urlWithRemovedBaseUrl, (String)basePath);
    }

    private String getBasePath() {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        try {
            URI url = new URI(baseUrl);
            return url.getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExternalImageUrl(String path) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return path;
            }
            return this.addAttachmentAndReturnCid(MailAttachments.newUrlImageAttachment(this.getAbsoluteUrl(path)));
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    protected String getAbsoluteUrl(String path) {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        try {
            URI uri = new URI(path);
            return uri.isAbsolute() ? path : StringUtils.stripEnd((String)baseUrl, (String)"/") + "/" + StringUtils.stripStart((String)path, (String)"/");
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    @Override
    public int getAttachmentsCount() {
        return this.mailAttachments.size();
    }

    @Override
    public Iterable<BodyPart> buildAttachmentsBodyParts() {
        return this.mailAttachments.entrySet().stream().map(entry -> this.buildMimeBodyPartFromMailAttachment((MailAttachment)entry.getKey(), (String)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BodyPart buildMimeBodyPartFromMailAttachment(MailAttachment mailAttachment, String cid) {
        BodyPart bodyPart = mailAttachment.buildBodyPart();
        if (bodyPart != null) {
            try {
                bodyPart.setHeader("Content-ID", String.format("<%s>", cid));
            }
            catch (MessagingException e) {
                log.warn("Cannot add 'Content-ID' header to mail part", (Throwable)e);
                return null;
            }
        } else {
            log.warn(" can not obtain {} bodyPart ", (Object)cid);
        }
        return bodyPart;
    }

    private MailAttachment createUserAvatarAttachment(ApplicationUser user) {
        String userName = null == user ? "anonymous" : user.getName();
        String avatarOwnerDescription = "user: " + userName;
        Avatar avatar = this.avatarService.getAvatarTagged(user, user);
        Optional<Avatar> jiraAvatar = this.getJiraAvatar(avatar);
        if (jiraAvatar.isPresent() && AvatarManagerImpl.isAvatarTranscodeable(jiraAvatar.get())) {
            return MailAttachments.newTranscodedAvatarAttachment(jiraAvatar.get(), avatarOwnerDescription, this.avatarManager);
        }
        return MailAttachments.newAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager);
    }

    private MailAttachment createAvatarAttachment(@Nonnull Avatar avatar, @Nullable Avatar.Size size, String avatarOwnerDescription) {
        Avatar.Size avatarSize = Optional.ofNullable(size).orElse(Avatar.Size.MEDIUM);
        if (AvatarManagerImpl.isAvatarTranscodeable(avatar)) {
            return MailAttachments.newTranscodedAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager, avatarSize);
        }
        return MailAttachments.newAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager, avatarSize);
    }

    private Optional<Avatar> getJiraAvatar(Avatar avatar) {
        try {
            Long avatarId = avatar.getId();
            if (avatarId == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.avatarManager.getById(avatarId));
        }
        catch (Exception e) {
            log.debug("Could not obtain JIRA avatar.", (Throwable)e);
            return Optional.empty();
        }
    }
}

