/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.builder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.mail.builder.EmailRenderer;
import com.atlassian.jira.mail.builder.RenderingMailQueueItem;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;

public class EmailBuilder {
    private final Email email;
    private TemplateSource subjectTemplate;
    private TemplateSource bodyTemplate;
    private Set<BodyPart> attachments = Sets.newHashSet();
    private Map<String, Object> templateParameters;

    public EmailBuilder(Email email, String mimeType, Locale recipientLocale, IssueEvent issueEvent) {
        this.email = email;
        this.email.setMimeType(mimeType);
        TemplateContextFactory templateContextFactory = (TemplateContextFactory)ComponentAccessor.getComponent(TemplateContextFactory.class);
        Map<String, Object> templateParams = templateContextFactory.getTemplateContext(recipientLocale, issueEvent).getTemplateParams();
        this.templateParameters = JiraMailQueueUtils.getContextParamsBody(templateParams);
    }

    public EmailBuilder(Email email, String mimeType, Locale recipientLocale) {
        this.email = email;
        this.email.setMimeType(mimeType);
        TemplateContextFactory templateContextFactory = (TemplateContextFactory)ComponentAccessor.getComponent(TemplateContextFactory.class);
        Map<String, Object> templateParams = templateContextFactory.getTemplateContext(recipientLocale).getTemplateParams();
        this.templateParameters = JiraMailQueueUtils.getContextParamsBody(templateParams);
    }

    public EmailBuilder(Email email, NotificationRecipient notificationRecipient, IssueEvent event) {
        this(email, EmailBuilder.getMimeTypeForFormat(notificationRecipient), I18nBean.getLocaleFromUser(notificationRecipient.getUser()), event);
    }

    public EmailBuilder(Email email, NotificationRecipient notificationRecipient) {
        this(email, EmailBuilder.getMimeTypeForFormat(notificationRecipient), I18nBean.getLocaleFromUser(notificationRecipient.getUser()));
    }

    public EmailBuilder addAttachment(BodyPart bodyPart) {
        this.attachments.add(bodyPart);
        return this;
    }

    public EmailBuilder addAttachments(Collection<BodyPart> bodyParts) {
        this.attachments.addAll(bodyParts);
        return this;
    }

    public EmailBuilder withSubject(String subjectTemplate) {
        this.subjectTemplate = TemplateSources.fragment((String)subjectTemplate);
        return this;
    }

    public EmailBuilder withSubjectFromFile(String subjectTemplatePath) {
        this.subjectTemplate = TemplateSources.file((String)subjectTemplatePath);
        return this;
    }

    public EmailBuilder withBody(String bodyTemplate) {
        this.bodyTemplate = TemplateSources.fragment((String)bodyTemplate);
        return this;
    }

    public EmailBuilder withBodyFromFile(String bodyTemplatePath) {
        this.bodyTemplate = TemplateSources.file((String)bodyTemplatePath);
        return this;
    }

    public EmailBuilder addParameters(Map<String, Object> templateParameters) {
        this.templateParameters.putAll(templateParameters);
        return this;
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.subjectTemplate);
        Preconditions.checkNotNull((Object)this.bodyTemplate);
        Preconditions.checkNotNull(this.templateParameters);
    }

    private EmailRenderer createEmailRenderer() {
        return new EmailRenderer(this.email, this.subjectTemplate, this.bodyTemplate, this.attachments, this.templateParameters);
    }

    public SingleMailQueueItem renderNowAsQueueItem() throws MessagingException {
        return new SingleMailQueueItem((com.atlassian.mail.Email)this.renderNow());
    }

    public Email renderNow() throws MessagingException {
        return this.createEmailRenderer().render();
    }

    public MailQueueItem renderLater() {
        return new RenderingMailQueueItem(this.createEmailRenderer());
    }

    private static String getMimeTypeForFormat(NotificationRecipient recipient) {
        if (recipient.isHtml()) {
            return "text/html";
        }
        return "text/plain";
    }
}

