/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.IssueTemplateContext;
import com.atlassian.jira.mail.NotificationRecipientProcessor;
import com.atlassian.jira.mail.TemplateIssue;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailingListCompiler {
    private static final Logger log = LoggerFactory.getLogger(MailingListCompiler.class);
    private static final String GETS_COMMENT_AND_ORIGINAL = "commentplusoriginal";
    private static final String GETS_COMMENT_NO_ORIGINAL = "commentnooriginal";
    private static final String NOCOMMENT = "nocomment";
    private final TemplateManager templateManager;
    private final ProjectRoleManager projectRoleManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public MailingListCompiler(TemplateManager templateManager, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.templateManager = templateManager;
        this.projectRoleManager = projectRoleManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Deprecated
    public static String getEmailAddresses(Set<String> addresses) {
        return Joiner.on((String)",").join(addresses);
    }

    @Deprecated
    public void sendLists(Set<NotificationRecipient> recipients, String sender, String senderFrom, Long templateId, String baseUrl, Map<String, Object> contextParams, MailThreader threader) throws VelocityException {
        this.prepareEmail(recipients, sender, senderFrom, templateId, baseUrl, contextParams, threader).stream().forEach(arg_0 -> ((MailQueue)this.getMailQueue()).addItem(arg_0));
    }

    public Collection<SingleMailQueueItem> prepareEmail(Set<NotificationRecipient> recipients, String sender, String senderFrom, Long templateId, String baseUrl, Map<String, Object> contextParams, MailThreader threader) throws VelocityException {
        NotificationCompiler compiler = new NotificationCompiler(recipients, sender, senderFrom, templateId, contextParams, threader);
        Object eventParams = contextParams.get("params");
        if (eventParams != null) {
            Object commentObject = contextParams.get("comment");
            Object worklogObject = contextParams.get("worklog");
            if (worklogObject != null) {
                Worklog worklog = (Worklog)worklogObject;
                ProjectRole roleLevel = worklog.getRoleLevel();
                String roleLevelName = roleLevel == null ? null : roleLevel.getName();
                Worklog originalWorklog = (Worklog)((Map)eventParams).get("originalworklog");
                String originalRoleLevelName = null;
                String originalGroupLevel = null;
                if (originalWorklog != null) {
                    ProjectRole originalRoleLevel = originalWorklog.getRoleLevel();
                    originalRoleLevelName = originalRoleLevel == null ? null : originalRoleLevel.getName();
                    originalGroupLevel = originalWorklog.getGroupLevel();
                }
                return compiler.evaluateForEvent((Map)eventParams, worklog.getGroupLevel(), roleLevelName, originalGroupLevel, originalRoleLevelName);
            }
            if (commentObject != null) {
                ProjectRole roleLevel;
                Comment comment = (Comment)commentObject;
                Comment originalComment = (Comment)((Map)eventParams).get("originalcomment");
                String originalRoleLevelName = null;
                String originalGroupLevel = null;
                if (originalComment != null) {
                    ProjectRole originalRoleLevel = originalComment.getRoleLevel();
                    originalRoleLevelName = originalRoleLevel == null ? null : originalRoleLevel.getName();
                    originalGroupLevel = originalComment.getGroupLevel();
                }
                String roleLevelName = (roleLevel = comment.getRoleLevel()) == null ? null : roleLevel.getName();
                return compiler.evaluateForEvent((Map)eventParams, comment.getGroupLevel(), roleLevelName, originalGroupLevel, originalRoleLevelName);
            }
            log.debug("The event does not have a comment or a worklog. Sending to all recipients.");
            return compiler.evaluateForAll();
        }
        log.debug("Do not have any context params. Sending to all recipients.");
        return compiler.evaluateForAll();
    }

    private Map<String, Map<String, Set<NotificationRecipient>>> groupEmailsByType(Set<NotificationRecipient> recipients, String group, String role, String originalGroup, String originalRole, TemplateIssue issue, boolean sendOnlyWhenInGroup) {
        HashMap<String, Map<String, Set<NotificationRecipient>>> recipientEmailsByType = new HashMap<String, Map<String, Set<NotificationRecipient>>>();
        HashMap usersGettingCommentAndOriginal = new HashMap();
        HashMap usersGettingCommentNoOriginal = new HashMap();
        HashMap<String, HashSet<NotificationRecipient>> usersNotGettingComment = new HashMap<String, HashSet<NotificationRecipient>>();
        recipientEmailsByType.put(GETS_COMMENT_AND_ORIGINAL, usersGettingCommentAndOriginal);
        recipientEmailsByType.put(GETS_COMMENT_NO_ORIGINAL, usersGettingCommentNoOriginal);
        recipientEmailsByType.put(NOCOMMENT, usersNotGettingComment);
        for (NotificationRecipient recipient : recipients) {
            HashMap<String, HashSet<Object>> currentGroup;
            if (this.recipientHasVisibility(group, role, recipient, issue)) {
                currentGroup = this.recipientHasVisibility(originalGroup, originalRole, recipient, issue) ? usersGettingCommentAndOriginal : usersGettingCommentNoOriginal;
            } else {
                if (sendOnlyWhenInGroup) continue;
                currentGroup = usersNotGettingComment;
            }
            String format = recipient.getFormat();
            HashSet<NotificationRecipient> currentUsers = (HashSet<NotificationRecipient>)currentGroup.get(format);
            if (currentUsers == null) {
                currentUsers = new HashSet<NotificationRecipient>();
                currentGroup.put(format, currentUsers);
            }
            currentUsers.add(recipient);
        }
        return recipientEmailsByType;
    }

    private boolean recipientHasVisibility(String group, String role, NotificationRecipient recipient, TemplateIssue issue) {
        return group == null && role == null || group != null && recipient.isInGroup(group) || role != null && issue != null && this.isInRole(recipient, issue.getProjectObject(), role);
    }

    private boolean isInRole(NotificationRecipient recipient, Project project, String role) {
        ApplicationUser user = recipient.getUserRecipient();
        if (user == null) {
            return false;
        }
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(role);
        return projectRole != null && this.projectRoleManager.isUserInProjectRole(user, projectRole, project);
    }

    private Collection<SingleMailQueueItem> evaluateEmails(Set<NotificationRecipient> textRecipients, Long templateId, String format, Map<String, Object> contextParams, String sender, String senderFrom, MailThreader threader) throws VelocityException {
        String subjectTemplate = this.templateManager.getTemplateContent(templateId, "subject");
        String bodyTemplate = this.templateManager.getTemplateContent(templateId, format);
        if (!textRecipients.isEmpty()) {
            NotificationRecipientProcessor processor = this.getNotificationRecipientProcessor(textRecipients, contextParams, sender, senderFrom, threader, subjectTemplate, bodyTemplate);
            return processor.evaluateEmails();
        }
        return Collections.emptyList();
    }

    private NotificationRecipientProcessor getNotificationRecipientProcessor(Set<NotificationRecipient> textRecipients, final Map<String, Object> contextParams, final String sender, final String senderFrom, final MailThreader threader, final String subjectTemplate, final String bodyTemplate) {
        return new NotificationRecipientProcessor(textRecipients){

            @Override
            Optional<SingleMailQueueItem> evaluateEmailForRecipient(NotificationRecipient recipient) throws Exception {
                ApplicationUser recipientUser = recipient.getUserRecipient();
                String recipientEmail = recipient.getEmail();
                if (recipientEmail == null || recipientEmail.length() == 0) {
                    if (recipientUser == null) {
                        log.warn("Can not send e-mail, e-mail address ('" + recipientEmail + "') not set. Skipping...");
                    } else {
                        String fullName = recipientUser.getDisplayName();
                        String userName = recipientUser.getName();
                        log.warn("Can not send e-mail to '" + fullName + "' [" + userName + "], e-mail address ('" + recipientEmail + "') not set. Skipping...");
                    }
                    return Optional.empty();
                }
                I18nBean i18nBean = new I18nBean(recipientUser);
                contextParams.put("i18n", i18nBean);
                IssueTemplateContext templateContext = (IssueTemplateContext)contextParams.get("context");
                if (templateContext != null) {
                    contextParams.put("eventTypeName", templateContext.getEventTypeName(i18nBean));
                }
                OutlookDate formatter = new OutlookDate(i18nBean.getLocale());
                contextParams.put("dateformatter", formatter);
                contextParams.put("datetimeformatter", MailingListCompiler.this.dateTimeFormatterFactory.formatter().withLocale(i18nBean.getLocale()));
                contextParams.put("lfbean", LookAndFeelBean.getInstance((ApplicationProperties)((ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class))));
                if (recipientUser != null) {
                    contextParams.put("recipient", recipientUser);
                }
                Email email = new Email(recipient.getEmail());
                email.setFrom(sender);
                email.setFromName(senderFrom);
                Optional<MailAttachmentsManager> attachmentsManager = Optional.ofNullable((MailAttachmentsManager)contextParams.get("attachmentsManager"));
                Iterable attachmentsBodyParts = attachmentsManager.map(MailAttachmentsManager::buildAttachmentsBodyParts).orElse(Lists.newArrayList());
                SingleMailQueueItem item = new EmailBuilder(email, recipient).addAttachments(Lists.newArrayList((Iterable)attachmentsBodyParts)).withSubject(subjectTemplate).withBody(bodyTemplate).addParameters(contextParams).renderNowAsQueueItem();
                item.setMailThreader(threader);
                return Optional.of(item);
            }

            @Override
            void handleException(NotificationRecipient recipient, Exception ex) {
                if (recipient == null) {
                    log.error("Failed adding mail, notification recipient was null", (Throwable)ex);
                } else {
                    log.error("Failed adding mail for notification recipient: [email=" + recipient.getEmail() + ", user=" + recipient.getUserRecipient() + ']', (Throwable)ex);
                }
            }
        };
    }

    @VisibleForTesting
    MailQueue getMailQueue() {
        return ComponentAccessor.getMailQueue();
    }

    private class NotificationCompiler {
        private final Set<NotificationRecipient> recipients;
        private final String sender;
        private final String senderFrom;
        private final Long templateId;
        private final Map<String, Object> contextParams;
        private final MailThreader threader;

        public NotificationCompiler(Set<NotificationRecipient> recipients, String sender, String senderFrom, Long templateId, Map<String, Object> contextParams, MailThreader threader) {
            this.recipients = recipients;
            this.sender = sender;
            this.senderFrom = senderFrom;
            this.templateId = templateId;
            this.contextParams = contextParams;
            this.threader = threader;
        }

        public Collection<SingleMailQueueItem> evaluateForEvent(Map eventParams, String groupLevel, String roleLevel, String originalGroupLevel, String originalRoleLevel) throws VelocityException {
            Object eventSource = eventParams.get("eventsource");
            if (eventSource != null) {
                log.debug("Do have an event source so from a comment or workflow");
                if ("action".equals(eventSource)) {
                    log.debug("Event source is action");
                    return this.sendLists(groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, true);
                }
                if ("workflow".equals(eventSource)) {
                    log.debug("Event source is workflow");
                    return this.sendLists(groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, false);
                }
                log.debug("Event source is unknown, this should not happen");
                return this.sendNoLevelsIgnoreGroup();
            }
            log.debug("No event source so must be from a subscription");
            return this.sendNoLevelsIgnoreGroup();
        }

        public Collection<SingleMailQueueItem> evaluateForAll() throws VelocityException {
            return this.sendNoLevelsIgnoreGroup();
        }

        private Collection<SingleMailQueueItem> sendNoLevelsIgnoreGroup() throws VelocityException {
            return this.sendLists(null, null, null, null, false);
        }

        private Collection<SingleMailQueueItem> sendLists(String groupLevel, String roleLevel, String originalGroupLevel, String originalRoleLevel, boolean sendOnlyWhenInGroup) throws VelocityException {
            ArrayList<SingleMailQueueItem> result = new ArrayList<SingleMailQueueItem>();
            TemplateIssue issue = (TemplateIssue)this.contextParams.get("issue");
            Map recipientEmailsByType = MailingListCompiler.this.groupEmailsByType(this.recipients, groupLevel, roleLevel, originalGroupLevel, originalRoleLevel, issue, sendOnlyWhenInGroup);
            result.addAll(this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.GETS_COMMENT_AND_ORIGINAL)));
            this.contextParams.remove("originalcomment");
            this.contextParams.remove("originalworklog");
            result.addAll(this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.GETS_COMMENT_NO_ORIGINAL)));
            this.contextParams.remove("comment");
            result.addAll(this.addEmailsToQueue((Map)recipientEmailsByType.get(MailingListCompiler.NOCOMMENT)));
            return result;
        }

        private Collection<SingleMailQueueItem> addEmailsToQueue(Map<String, Set<NotificationRecipient>> userSets) throws VelocityException {
            return userSets.entrySet().stream().map(entry -> MailingListCompiler.this.evaluateEmails((Set)entry.getValue(), this.templateId, (String)entry.getKey(), this.contextParams, this.sender, this.senderFrom, this.threader)).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

