/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ClusterLicenseCheckImpl
implements ClusterLicenseCheck {
    @Override
    public ClusterLicenseCheck.ClusterResult evaluate() {
        JiraLicenseManager licenseManager = (JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class);
        if (!licenseManager.isLicenseSet()) {
            return new ClusterLicenseCheck.ClusterFailure((Iterable<? extends LicenseDetails>)ImmutableList.of(), "No licenses present", ClusterLicenseCheck.FailureReason.NO_LICENSES);
        }
        ImmutableList licenses = ImmutableList.copyOf((Iterable)licenseManager.getLicenses());
        List<LicenseDetails> nonDataCentreLicenses = licenses.stream().filter(license -> !license.isDataCenter()).collect(Collectors.toList());
        if (!nonDataCentreLicenses.isEmpty()) {
            if (licenses.size() != nonDataCentreLicenses.size()) {
                String whichLicenses = ClusterLicenseCheckImpl.describeLicenses(nonDataCentreLicenses);
                return new ClusterLicenseCheck.ClusterFailure(nonDataCentreLicenses, "Clustering not permitted as there are non-DataCenter licenses present: " + whichLicenses, ClusterLicenseCheck.FailureReason.MIXED_LICENSES);
            }
            return new ClusterLicenseCheck.ClusterFailure(nonDataCentreLicenses, "Instance is not licensed for clustering", ClusterLicenseCheck.FailureReason.NO_DC_LICENSE);
        }
        return new ClusterLicenseCheck.ClusterResult((Iterable<? extends LicenseDetails>)ImmutableList.of(), "", null);
    }

    @VisibleForTesting
    static String describeLicenses(Collection<LicenseDetails> licenses) {
        return licenses.stream().map(LicenseDetails::getDescription).map(desc -> "\"" + desc + "\"").collect(Collectors.joining(", "));
    }
}

