/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class StatusCategoryClauseValuesGenerator
implements ClauseValuesGenerator {
    private final StatusCategoryManager statusCategoryManager;

    public StatusCategoryClauseValuesGenerator(StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = statusCategoryManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List statusCategories = this.statusCategoryManager.getUserVisibleStatusCategories();
        ArrayList<ClauseValuesGenerator.Result> results = new ArrayList<ClauseValuesGenerator.Result>(Math.min(statusCategories.size(), maxNumResults));
        for (StatusCategory statusCategory : statusCategories) {
            if (results.size() == maxNumResults) break;
            this.addCategoryAliasOrName(valuePrefix, statusCategory, results);
        }
        return new ClauseValuesGenerator.Results(results);
    }

    private void addCategoryAliasOrName(String valuePrefix, StatusCategory statusCategory, List<ClauseValuesGenerator.Result> results) {
        if (StringUtils.isBlank((CharSequence)valuePrefix) || CaseFolding.foldString((String)statusCategory.getPrimaryAlias()).startsWith(CaseFolding.foldString((String)valuePrefix))) {
            results.add(new ClauseValuesGenerator.Result(statusCategory.getPrimaryAlias()));
        }
    }

    Locale getLocale(ApplicationUser searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

