/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class IssueLinkTypesClauseValidator
implements ClauseValidator {
    private final JqlOperandResolver operandResolver;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private SupportedOperatorsValidator supportedOperatorsValidator;

    public IssueLinkTypesClauseValidator(JqlOperandResolver operandResolver, IssueLinkTypeManager issueLinkTypeManager, SupportedOperatorsValidator supportedOperatorsValidator) {
        this.operandResolver = operandResolver;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.supportedOperatorsValidator = supportedOperatorsValidator;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSet messages = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (messages.hasAnyMessages()) {
            return messages;
        }
        I18nHelper i18n = this.getI18nBean(searcher);
        List values = this.operandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        this.validateInternal(values.stream().filter(z -> !z.isEmpty()).map(QueryLiteral::asString).collect(Collectors.toList()), arg_0 -> ((MessageSet)messages).addErrorMessage(arg_0), i18n);
        return messages;
    }

    protected I18nHelper getI18nBean(ApplicationUser searcher) {
        return new I18nBean(searcher);
    }

    public void validateInternal(Collection<String> values, Consumer<String> onErrorAction, I18nHelper i18n) {
        values.stream().filter(this::isNotValid).map(invalidLinkType -> i18n.getText("jira.jql.clause.issuelinktype.description", invalidLinkType)).forEach(onErrorAction);
    }

    private boolean isNotValid(String linkType) {
        return this.issueLinkTypeManager.getIssueLinkTypesByOutwardDescription(linkType).isEmpty() && this.issueLinkTypeManager.getIssueLinkTypesByInwardDescription(linkType).isEmpty();
    }
}

