/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.query.operand.EmptyOperand;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class StatusCategoryResolver
implements NameResolver<StatusCategory> {
    private final StatusCategoryManager statusCategoryManager;

    public StatusCategoryResolver(StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = statusCategoryManager;
    }

    public Set<StatusCategory> getStatusCategories(Collection<QueryLiteral> queryLiterals) {
        HashSet<StatusCategory> categories = new HashSet<StatusCategory>(queryLiterals.size());
        for (QueryLiteral rawValue : queryLiterals) {
            Option<StatusCategory> category = this.getStatusCategory(rawValue);
            if (!category.isDefined()) continue;
            categories.add((StatusCategory)category.get());
        }
        return categories;
    }

    public Option<StatusCategory> getStatusCategory(QueryLiteral rawValue) {
        if (rawValue.getSourceOperand() instanceof EmptyOperand) {
            return Option.some((Object)this.statusCategoryManager.getDefaultStatusCategory());
        }
        return this.forId(rawValue.getLongValue()).orElse(this.forKey(rawValue.getStringValue())).orElse(this.forName(rawValue.getStringValue()));
    }

    public Option<StatusCategory> forId(Long id) {
        return id == null ? Option.none() : Option.option((Object)this.statusCategoryManager.getStatusCategory(id));
    }

    public Option<StatusCategory> forKey(String key) {
        return key == null ? Option.none() : Option.option((Object)this.statusCategoryManager.getStatusCategoryByKey(key));
    }

    public Option<StatusCategory> forName(String name) {
        return name == null ? Option.none() : Option.option((Object)this.statusCategoryManager.getStatusCategoryByName(name));
    }

    public List<String> getIdsFromName(String name) {
        Option<StatusCategory> category = this.forName(name);
        if (!category.isEmpty()) {
            return ImmutableList.of((Object)((StatusCategory)category.get()).getId().toString());
        }
        return ImmutableList.of();
    }

    public boolean nameExists(String name) {
        return this.forName(name).isDefined();
    }

    public boolean idExists(Long id) {
        return this.forId(id).isDefined();
    }

    public StatusCategory get(Long id) {
        return (StatusCategory)this.forId(id).getOrNull();
    }

    @Nonnull
    public Collection<StatusCategory> getAll() {
        return this.statusCategoryManager.getStatusCategories();
    }
}

