/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.jql.clause.WorklogClausesTransformerVisitor;
import com.atlassian.jira.jql.query.ContextAwareQueryVisitor;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.QueryVisitorUtil;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import org.apache.lucene.search.Query;

@InjectableComponent
public class QueryVisitor {
    protected final ContextAwareQueryVisitor.ContextAwareQueryVisitorFactory contextAwareQueryVisitorFactory;
    private final WorklogClausesTransformerVisitor.Factory worklogsVisitorFactory;
    private final DeMorgansVisitor.DeMorgansVisitorFactory deMorgansVisitorFactory;

    public QueryVisitor(ContextAwareQueryVisitor.ContextAwareQueryVisitorFactory contextAwareQueryVisitorFactory, WorklogClausesTransformerVisitor.Factory worklogsVisitorFactory, DeMorgansVisitor.DeMorgansVisitorFactory deMorgansVisitorFactory) {
        this.contextAwareQueryVisitorFactory = contextAwareQueryVisitorFactory;
        this.worklogsVisitorFactory = worklogsVisitorFactory;
        this.deMorgansVisitorFactory = deMorgansVisitorFactory;
    }

    public Query createQuery(Clause clause, QueryCreationContext queryCreationContext) {
        Clause normalisedClause = (Clause)clause.accept((ClauseVisitor)this.deMorgansVisitorFactory.createDeMorgansVisitor());
        Clause worklogConditionsMergedClause = (Clause)normalisedClause.accept((ClauseVisitor)this.worklogsVisitorFactory.create(queryCreationContext));
        QueryFactoryResult queryFactoryResult = (QueryFactoryResult)worklogConditionsMergedClause.accept((ClauseVisitor)this.createContextAwareQueryVisitor(queryCreationContext, worklogConditionsMergedClause));
        return QueryVisitorUtil.makeQuery(queryFactoryResult);
    }

    protected ContextAwareQueryVisitor createContextAwareQueryVisitor(QueryCreationContext queryCreationContext, Clause clause) {
        return this.contextAwareQueryVisitorFactory.createVisitor(queryCreationContext, clause);
    }

    @InjectableComponent
    public static class QueryVisitorFactory {
        private final ContextAwareQueryVisitor.ContextAwareQueryVisitorFactory contextAwareQueryVisitorFactory;
        private final WorklogClausesTransformerVisitor.Factory worklogsVisitorFactory;
        private final DeMorgansVisitor.DeMorgansVisitorFactory deMorgansVisitorFactory;

        public QueryVisitorFactory(ContextAwareQueryVisitor.ContextAwareQueryVisitorFactory contextAwareQueryVisitorFactory, WorklogClausesTransformerVisitor.Factory worklogsVisitorFactory, DeMorgansVisitor.DeMorgansVisitorFactory deMorgansVisitorFactory) {
            this.contextAwareQueryVisitorFactory = contextAwareQueryVisitorFactory;
            this.worklogsVisitorFactory = worklogsVisitorFactory;
            this.deMorgansVisitorFactory = deMorgansVisitorFactory;
        }

        public QueryVisitor createQueryVisitorWithCustomQueryRegistry(final QueryRegistry queryRegistry) {
            return new QueryVisitor(this.contextAwareQueryVisitorFactory, this.worklogsVisitorFactory, this.deMorgansVisitorFactory){

                @Override
                protected ContextAwareQueryVisitor createContextAwareQueryVisitor(QueryCreationContext queryCreationContext, Clause clause) {
                    return this.contextAwareQueryVisitorFactory.createVisitorWithCustomQueryRegistry(queryCreationContext, clause, queryRegistry);
                }
            };
        }
    }
}

