/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.query.operator.Operator;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateEqualityQueryFactory
extends AbstractDateOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(DateEqualityQueryFactory.class);
    private final JqlDateSupport jqlDateSupport;

    public DateEqualityQueryFactory(JqlDateSupport jqlDateSupport) {
        super(jqlDateSupport);
        this.jqlDateSupport = jqlDateSupport;
    }

    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug(String.format("Creating an equality query for a single value for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS));
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug(String.format("Creating an equality query for multiple values for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.IN, Operator.NOT_IN));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.getDateValues(rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.getDateValues(rawValues));
        }
        return QueryFactoryResult.createFalseResult();
    }

    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.debug(String.format("Creating an equality query for an empty value for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS));
        return QueryFactoryResult.createFalseResult();
    }

    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private Query handleEquals(String fieldName, Date value) {
        return LongPoint.newExactQuery((String)fieldName, (long)value.getTime());
    }

    private Query handleNotEquals(String fieldName, Date value) {
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        Long indexedValue = value.getTime();
        combined.add(LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)(indexedValue - 1L)), BooleanClause.Occur.SHOULD);
        combined.add(LongPoint.newRangeQuery((String)fieldName, (long)(indexedValue + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.SHOULD);
        return combined.build();
    }

    private QueryFactoryResult handleIn(String fieldName, List<Date> values) {
        if (values.size() == 1) {
            Date date = values.get(0);
            Query query = date == null ? this.getIsEmptyQuery(fieldName) : this.handleEquals(fieldName, date);
            return new QueryFactoryResult(query);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (Date value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleEquals(fieldName, value), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined.build());
    }

    private QueryFactoryResult handleNotIn(String fieldName, List<Date> values) {
        if (values.size() == 1) {
            Date date = values.get(0);
            Query query = date == null ? this.getIsNotEmptyQuery(fieldName) : this.handleNotEquals(fieldName, date);
            return new QueryFactoryResult(query);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (Date value : values) {
            if (value == null) {
                combined.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleNotEquals(fieldName, value), BooleanClause.Occur.MUST);
        }
        return new QueryFactoryResult((Query)combined.build());
    }

    private Query getIsEmptyQuery(String fieldName) {
        QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery((String)fieldName), true);
        return QueryFactoryResult.wrapWithVisibilityQuery((String)fieldName, (QueryFactoryResult)result).getLuceneQuery();
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery((String)fieldName);
    }
}

