/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.issue.watchers.WatchedIssuesAccessor;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.lucene.search.Collector;

public class DefaultWatchedIssuesAccessor
implements WatchedIssuesAccessor {
    private final WatcherManager watcherManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory factory;

    public DefaultWatchedIssuesAccessor(@Nonnull WatcherManager watcherManager, @Nonnull SearchProvider searchProvider, @Nonnull SearchProviderFactory factory) {
        this.watcherManager = (WatcherManager)Assertions.notNull((String)"watcherManager", (Object)watcherManager);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.factory = (SearchProviderFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    public Iterable<Long> getWatchedIssueIds(ApplicationUser watcher, ApplicationUser searcher, WatchedIssuesAccessor.Security security) {
        FieldHitCollector collector = new FieldHitCollector("issue_id");
        Query query = DefaultWatchedIssuesAccessor.getQuery(watcher);
        try {
            this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)searcher).overrideSecurity(security == WatchedIssuesAccessor.Security.OVERRIDE), (Collector)collector);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        List<String> issueIds = collector.getValues();
        return Iterables.transform(issueIds, Long::valueOf);
    }

    public boolean isWatchingEnabled() {
        return this.watcherManager.isWatchingEnabled();
    }

    static Query getQuery(ApplicationUser user) {
        return JqlQueryBuilder.newBuilder().where().watcherUser(user.getName()).endWhere().buildQuery();
    }
}

