/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestPreviousView;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import java.util.HashMap;

public class DefaultSearchRequestPreviousView
implements SearchRequestPreviousView {
    private static final String PREVIOUS_VIEW_TEMPLATE_NAME = "previous";
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;

    public DefaultSearchRequestPreviousView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getLinkToPrevious(SearchRequest searchRequest, JiraResourcedModuleDescriptor<?> descriptor) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String baseUrl = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext().getBaseUrl();
        params.put("i18n", this.authenticationContext.getI18nHelper());
        params.put("link", SearchRequestViewUtils.getLink(searchRequest, baseUrl, this.authenticationContext.getUser()));
        return descriptor.getHtml(PREVIOUS_VIEW_TEMPLATE_NAME, params);
    }

    @Override
    public String getLinkToPrevious(Issue issue, JiraResourcedModuleDescriptor<?> descriptor) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String baseUrl = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext().getBaseUrl();
        params.put("i18n", this.authenticationContext.getI18nHelper());
        params.put("link", baseUrl + "/browse/" + issue.getKey());
        return descriptor.getHtml(PREVIOUS_VIEW_TEMPLATE_NAME, params);
    }
}

