/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueCreatedAction
extends AbstractIssueAction {
    private static final String PLUGIN_TEMPLATES = "templates/plugins/";
    private static final Logger log = LoggerFactory.getLogger(IssueCreatedAction.class);
    private final DateTimeFormatter formatter;
    private final I18nHelper i18nHelper;
    private final UserFormatManager userFormatManager;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;
    private final Issue issue;

    public IssueCreatedAction(IssueTabPanelModuleDescriptor descriptor, DateTimeFormatter formatter, UserFormatManager userFormatManager, I18nHelper i18nHelper, AvatarService avatarService, JiraAuthenticationContext authenticationContext, Issue issue) {
        super(descriptor);
        this.formatter = formatter;
        this.i18nHelper = i18nHelper;
        this.userFormatManager = userFormatManager;
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.issue = issue;
    }

    public Date getTimePerformed() {
        return this.getCreatedDate();
    }

    protected void populateVelocityParams(Map params) {
        params.put("issuecreatedaction", this);
        params.put("stringUtils", new StringUtils());
        params.put("userformat", this.userFormatManager);
        params.put("i18n", this.i18nHelper);
    }

    public String getHtml() {
        String templateName = "jira/issuetabpanels/issuecreated.vm";
        VelocityTemplatingEngine templatingEngine = (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            this.populateVelocityParams(params);
            return templatingEngine.render(TemplateSources.file((String)"templates/plugins/jira/issuetabpanels/issuecreated.vm")).applying((Map)params).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error while rendering velocity template for 'jira/issuetabpanels/issuecreated.vm'.", (Throwable)e);
            return "Velocity template generation failed.";
        }
    }

    public Long getId() {
        return this.issue.getId();
    }

    public String getCreatorId() {
        return this.issue.getCreatorId();
    }

    public Timestamp getCreatedDate() {
        return this.issue.getCreated();
    }

    public String getCreatedDateHtml() {
        return StringEscapeUtils.escapeHtml4((String)this.formatter.forLoggedInUser().format((Date)this.getCreatedDate()));
    }

    public String getCreatedDateIso8601Html() {
        return StringEscapeUtils.escapeHtml4((String)this.formatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)this.getCreatedDate()));
    }

    public String getUserProfileHtml() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("avatarURL", this.getAvatarURL(this.issue.getCreator()));
        if (this.issue.getCreatorId() == null) {
            parameters.put("username", this.i18nHelper.getText("creator.types.nocreator"));
        }
        return this.userFormatManager.formatUserkey(this.issue.getCreatorId(), "profileLinkActionHeader", "issuecreator_" + this.issue.getId(), parameters);
    }

    private String getAvatarURL(ApplicationUser applicationUser) {
        return this.avatarService.getAvatarURL(this.authenticationContext.getUser(), applicationUser, Avatar.Size.NORMAL).toString();
    }
}

