/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.CommentSummary;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.issue.tabpanels.CommentAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CommentTabPanel
extends AbstractIssueTabPanel3 {
    private final CommentManager commentManager;
    private final CommentPermissionManager commentPermissionManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final CommentFieldRenderer commentFieldRenderer;
    private final CommentPropertyService commentPropertyService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public CommentTabPanel(CommentManager commentManager, CommentPermissionManager commentPermissionManager, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, DateTimeFormatter dateTimeFormatter, SoyTemplateRendererProvider soyTemplateRendererProvider, CommentFieldRenderer commentFieldRenderer, CommentPropertyService commentPropertyService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.commentManager = commentManager;
        this.commentPermissionManager = commentPermissionManager;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.commentFieldRenderer = commentFieldRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.commentPropertyService = commentPropertyService;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    public List<IssueAction> getActions(GetActionsRequest request) {
        List<IssueAction> commentActions = this.getComments(request);
        if (commentActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocomments"));
            return Collections.singletonList(action);
        }
        Collections.sort(commentActions, IssueActionComparator.COMPARATOR);
        return commentActions;
    }

    private List<IssueAction> getComments(GetActionsRequest request) {
        int totalCommentCount;
        List commentsForIssue;
        Issue issue = request.issue();
        ApplicationUser user = request.loggedInUser();
        if (request.isShowAll()) {
            commentsForIssue = this.commentManager.getCommentsForUser(issue, user);
            totalCommentCount = commentsForIssue.size();
        } else {
            Optional<Long> focusId = Optional.ofNullable(request.getFocusId()).filter(StringUtils::isNumeric).map(Long::parseLong);
            CommentSummary commentSummary = this.commentManager.getCommentSummary(user, issue, focusId);
            commentsForIssue = commentSummary.getComments();
            totalCommentCount = commentSummary.getTotal();
        }
        ArrayList commentActions = Lists.newArrayListWithCapacity((int)commentsForIssue.size());
        CommentEditablePermission permissions = new CommentEditablePermission(this.issueManager, this.commentManager, this.commentPermissionManager, user, issue);
        this.addShowMoreLinkIfNecessary(request, totalCommentCount, commentsForIssue, commentActions);
        for (Comment comment : commentsForIssue) {
            commentActions.add(new CommentAction(this.descriptor, comment, permissions.canEdit(comment), permissions.canDelete(comment), false, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter, this.commentFieldRenderer, this.commentPropertyService, this.jiraAuthenticationContext));
        }
        return commentActions;
    }

    private void addShowMoreLinkIfNecessary(GetActionsRequest request, int totalCommentCount, List<Comment> commentsForIssue, List<IssueAction> commentActions) {
        if (totalCommentCount > commentsForIssue.size()) {
            int numberHiddenComments = totalCommentCount - 5;
            String showOlder = this.soyTemplateRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.IssueTabPanels.Comment.showOlder", MapBuilder.build((Object)"issueKey", (Object)request.issue().getKey(), (Object)"numberHiddenComments", (Object)numberHiddenComments));
            commentActions.add((IssueAction)new GenericMessageAction(showOlder));
        }
    }

    private static class CommentEditablePermission {
        private final IssueManager issueManager;
        private final CommentManager commentManager;
        private final CommentPermissionManager commentPermissionManager;
        private final ApplicationUser user;
        boolean issueIsInEditableWorkflow = false;
        boolean canDeleteAllComments = false;
        boolean canDeleteOwnComments = false;
        boolean canEditAllComments = false;
        boolean canEditOwnComments = false;

        public CommentEditablePermission(IssueManager issueManager, CommentManager commentManager, CommentPermissionManager commentPermissionManager, ApplicationUser user, Issue issue) {
            this.issueManager = issueManager;
            this.commentManager = commentManager;
            this.commentPermissionManager = commentPermissionManager;
            this.user = user;
            this.init(issue);
        }

        private void init(Issue issue) {
            this.issueIsInEditableWorkflow = this.issueManager.isEditable(issue);
            this.canDeleteAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteAllPermission(this.user, issue);
            this.canDeleteOwnComments = this.canDeleteAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteOwnPermission(this.user, issue);
            this.canEditAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditAllPermission(this.user, issue);
            this.canEditOwnComments = this.canEditAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditOwnPermission(this.user, issue);
        }

        public boolean canDelete(Comment comment) {
            return this.canDeleteAllComments || this.canDeleteOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }

        public boolean canEdit(Comment comment) {
            return this.canEditAllComments || this.canEditOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }
    }
}

