/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.renderer.HistoryMetadataRenderHelper;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.util.JiraDurationUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;

public class ChangeHistoryAction
extends AbstractIssueAction {
    private final ChangeHistory changeHistory;
    private final boolean showHeader;
    private final AttachmentManager attachmentManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final CustomFieldManager customFieldManager;
    private final DateTimeFormatter formatter;
    private final Issue issue;
    private final DateTimeFieldChangeLogHelper changeLogHelper;
    private final HistoryMetadata historyMetadata;
    private final HistoryMetadataRenderHelper historyMetadataRenderHelper;

    public ChangeHistoryAction(IssueTabPanelModuleDescriptor descriptor, ChangeHistory changeHistory, boolean showHeader, AttachmentManager attachmentManager, JiraDurationUtils jiraDurationUtils, CustomFieldManager customFieldManager, DateTimeFormatter formatter, Issue issue, DateTimeFieldChangeLogHelper changeLogHelper, HistoryMetadata historyMetadata, HistoryMetadataRenderHelper historyMetadataRenderHelper) {
        super(descriptor);
        this.changeHistory = changeHistory;
        this.showHeader = showHeader;
        this.attachmentManager = attachmentManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.customFieldManager = customFieldManager;
        this.formatter = formatter;
        this.issue = issue;
        this.changeLogHelper = changeLogHelper;
        this.historyMetadata = historyMetadata;
        this.historyMetadataRenderHelper = historyMetadataRenderHelper;
    }

    public Date getTimePerformed() {
        return this.getCreatedDate();
    }

    protected void populateVelocityParams(Map params) {
        params.put("changehistory", this);
        params.put("metadataHelper", this.historyMetadataRenderHelper);
        params.put("stringUtils", new StringUtils());
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public Long getId() {
        return this.changeHistory.getId();
    }

    public String getAuthor() {
        return this.changeHistory.getAuthorKey();
    }

    public String getFullName() {
        return this.changeHistory.getAuthorDisplayName();
    }

    public Timestamp getCreatedDate() {
        return this.changeHistory.getTimePerformed();
    }

    public String getCreatedDateHtml() {
        return StringEscapeUtils.escapeHtml4((String)this.formatter.forLoggedInUser().format((Date)this.getCreatedDate()));
    }

    public String getCreatedDateIso8601Html() {
        return StringEscapeUtils.escapeHtml4((String)this.formatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)this.getCreatedDate()));
    }

    public String getComment() {
        return this.changeHistory.getComment();
    }

    public String getLevel() {
        return this.changeHistory.getLevel();
    }

    public List getChangeItems() {
        return this.changeHistory.getChangeItems();
    }

    public boolean isAttachmentValid(String fileId) {
        try {
            return fileId != null && this.attachmentManager.getAttachment(new Long(fileId)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDateField(String fieldName) {
        if ("duedate".equals(fieldName.toLowerCase())) {
            return true;
        }
        CustomField customField = this.findDateCustomField(fieldName);
        return customField != null;
    }

    public String formatDateValue(String value, String string, String fieldName) {
        if ("duedate".equals(fieldName.toLowerCase())) {
            return this.changeLogHelper.renderChangeHistoryValueDate(value, string);
        }
        CustomField customField = this.findDateCustomField(fieldName);
        if (customField == null) {
            return string;
        }
        if (customField.getCustomFieldType() instanceof DateTimeCFType) {
            return this.changeLogHelper.renderChangeHistoryValueDateTime(value, string);
        }
        return this.changeLogHelper.renderChangeHistoryValueDate(value, string);
    }

    public String formatValueStringForDisplay(String value) {
        if (value == null) {
            return "";
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private CustomField findDateCustomField(final String fieldName) {
        CustomField customField;
        List customFieldObjects = this.customFieldManager.getCustomFieldObjects(this.issue.getProjectId(), this.issue.getIssueTypeId());
        try {
            customField = (CustomField)Iterables.find((Iterable)customFieldObjects, (Predicate)new Predicate<CustomField>(){

                public boolean apply(@Nullable CustomField customField) {
                    return customField.getName().equals(fieldName) && (customField.getCustomFieldType() instanceof DateCFType || customField.getCustomFieldType() instanceof DateTimeCFType);
                }
            });
        }
        catch (NoSuchElementException ex) {
            return null;
        }
        return customField;
    }

    public String getPrettyDuration(String duration) {
        return this.jiraDurationUtils.getFormattedDuration(new Long(duration));
    }

    public HistoryMetadata getHistoryMetadata() {
        return this.historyMetadata;
    }
}

