/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import java.util.Map;
import webwork.action.Action;

@NonInjectableComponent
public class WorkRatioSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final SimpleFieldSearchConstants constants;
    private final WorkRatioSearcherConfig config;

    public WorkRatioSearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, SimpleFieldSearchConstants searchConstants, String searcherNameKey, FieldVisibilityManager fieldVisibilityManager, WorkRatioSearcherConfig config) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants, searcherNameKey);
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.constants = searchConstants;
        this.config = config;
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, user);
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderEditTemplate("workratio-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderViewTemplate("workratio-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }

    protected Map<String, Object> getVelocityParams(ApplicationUser searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        velocityParams.put("minField", this.config.getMinField());
        velocityParams.put("maxField", this.config.getMaxField());
        try {
            int min = Integer.parseInt((String)fieldValuesHolder.get((Object)this.config.getMinField()));
            int max = Integer.parseInt((String)fieldValuesHolder.get((Object)this.config.getMaxField()));
            if (min > max) {
                velocityParams.put("minGreaterThanMax", true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return velocityParams;
    }
}

