/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.providers;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.property.AliasClauseInformation;
import com.atlassian.jira.index.property.JqlAliasManager;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.DocumentWithId;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.metrics.LuceneQueryExecutionEvent;
import com.atlassian.jira.issue.search.metrics.LuceneQueryMetrics;
import com.atlassian.jira.issue.search.optimizers.DeterminedProjectsExtractor;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.LongSortComparatorSource;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparatorSource;
import com.atlassian.jira.issue.search.providers.EmptyJqlSearchEvent;
import com.atlassian.jira.issue.search.providers.PropertyTypeInfoQueryModifier;
import com.atlassian.jira.issue.search.providers.SearchUnknownResultSizeEvent;
import com.atlassian.jira.issue.search.util.PermissionQueryCache;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import com.atlassian.query.clause.Property;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearchProvider
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(LuceneSearchProvider.class);
    private static final int DEFAULT_SEARCH_LIMIT = 1000;
    private static final int MAX_ALLOWED_SEARCH_LIMIT = 100000;
    private static final String RESULTS_LIMIT_DISABLED_FEATURE_KEY = "jira.lucene.search.filter.limit.disabled";
    private static final String TOP_DOCS_COLLECTOR = "TopDocs";
    private final PermissionsFilterGenerator permissionsFilterGenerator;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchSortUtil searchSortUtil;
    private final LuceneQueryBuilder luceneQueryBuilder;
    private final JqlAliasManager jqlAliasManager;
    private final FeatureManager featureManager;
    private final EventPublisher eventPublisher;
    private final SearchProviderFactory searchProviderFactory;
    private final PermissionQueryCache permissionQueryCache;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final DeterminedProjectsExtractor projectsExtractor;
    private final LuceneQueryMetrics luceneQueryMetrics;
    private final PropertyTypeInfoQueryModifier propertyTypeInfoQueryModifier;

    public LuceneSearchProvider(SearchProviderFactory searchProviderFactory, PermissionsFilterGenerator permissionsFilterGenerator, SearchHandlerManager searchHandlerManager, SearchSortUtil searchSortUtil, LuceneQueryBuilder luceneQueryBuilder, JqlAliasManager jqlAliasManager, FeatureManager featureManager, EventPublisher eventPublisher, PermissionQueryCache permissionQueryCache, ApplicationProperties applicationProperties, ProjectManager projectManager, PluginIndexConfigurationManager pluginIndexConfigurationManager) {
        this.searchProviderFactory = searchProviderFactory;
        this.permissionsFilterGenerator = permissionsFilterGenerator;
        this.searchHandlerManager = searchHandlerManager;
        this.searchSortUtil = searchSortUtil;
        this.luceneQueryBuilder = luceneQueryBuilder;
        this.jqlAliasManager = jqlAliasManager;
        this.featureManager = featureManager;
        this.eventPublisher = eventPublisher;
        this.permissionQueryCache = permissionQueryCache;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.propertyTypeInfoQueryModifier = new PropertyTypeInfoQueryModifier(pluginIndexConfigurationManager);
        this.projectsExtractor = new DeterminedProjectsExtractor();
        this.luceneQueryMetrics = new LuceneQueryMetrics();
    }

    private ManagedIndexSearcher getIssueSearcher() {
        return this.searchProviderFactory.getSearcher("issues");
    }

    public SearchResults<DocumentWithId> search(SearchQuery query, PagerFilter pager, Set<String> fieldsToLoad) throws SearchException {
        return this.search(query.getQuery(), query.getUser(), pager, fieldsToLoad, query.getLuceneQuery(), query.isOverrideSecurity());
    }

    public SearchResults<DocumentWithId> search(SearchQuery query, PagerFilter pager) throws SearchException {
        return this.search(query, pager, null);
    }

    public long getHitCount(SearchQuery query) throws SearchException {
        return this.getHitCount(query.getQuery(), query.getUser(), query.isOverrideSecurity(), this.getIssueSearcher());
    }

    public void search(SearchQuery query, Collector collector) throws SearchException {
        this.search(query.getQuery(), query.getUser(), collector, query.getLuceneQuery(), query.isOverrideSecurity());
    }

    private long getHitCount(com.atlassian.query.Query searchQuery, ApplicationUser searchUser, boolean overrideSecurity, ManagedIndexSearcher issueSearcher) throws SearchException {
        if (this.shouldNotSearchWithEmptyJql(searchQuery, false)) {
            return 0L;
        }
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_READS);
        try {
            Query permissionsQuery = this.getPermissionsQuery(overrideSecurity, searchUser, this.getQueryProjects(searchQuery));
            Query finalQuery = this.createLuceneQuery(searchQuery, null, searchUser, overrideSecurity);
            TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
            issueSearcher.search(LuceneSearchProvider.wrapFilterQuery(permissionsQuery, finalQuery), (Collector)hitCountCollector);
            int totalHits = hitCountCollector.getTotalHits();
            long elapsedTime = opTimer.end().getMillisecondsTaken();
            this.publishMetricEvent(searchQuery, finalQuery, elapsedTime, totalHits, hitCountCollector.getClass().toString());
            return totalHits;
        }
        catch (IOException e) {
            throw new SearchException((Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TopDocs getHits(com.atlassian.query.Query searchQuery, ApplicationUser searchUser, SortField[] sortField, Query andQuery, boolean overrideSecurity, PagerFilter pager) throws SearchException {
        if (this.shouldNotSearchWithEmptyJql(searchQuery, true)) {
            return null;
        }
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_READS);
        try (Ticker ignored = Timers.start((String)"Lucene Search");){
            Query permissionsQuery = this.getPermissionsQuery(overrideSecurity, searchUser, this.getQueryProjects(searchQuery));
            Query finalQuery = this.createLuceneQuery(searchQuery, andQuery, searchUser, overrideSecurity);
            TopDocs topDocs = this.runSearch(finalQuery, permissionsQuery, sortField, pager);
            long elapsedTime = opTimer.end().getMillisecondsTaken();
            if (topDocs != null) {
                this.publishMetricEvent(searchQuery, finalQuery, elapsedTime, (int)topDocs.totalHits, TOP_DOCS_COLLECTOR);
            }
            if (log.isDebugEnabled()) {
                log.debug("JQL sorts: " + Arrays.toString(sortField));
            }
            TopDocs topDocs2 = topDocs;
            return topDocs2;
        }
        catch (IOException e) {
            throw new SearchException((Exception)e);
        }
    }

    private void publishMetricEvent(com.atlassian.query.Query searchQuery, Query finalQuery, long elapsedTime, int totalHits, String collectorType) {
        this.eventPublisher.publish((Object)new LuceneQueryExecutionEvent(searchQuery, this.luceneQueryMetrics.numberOfClausesPerField(finalQuery), elapsedTime, totalHits, collectorType));
    }

    private boolean shouldNotSearchWithEmptyJql(com.atlassian.query.Query query, boolean logEmptyQueryUsage) {
        boolean shouldNotSearch;
        if (query == null) {
            return true;
        }
        boolean emptyJqlReturnsNoDataEnabled = this.applicationProperties.getOption("jira.empty.jql.returns.no.data.enabled");
        boolean hasEmptyQuery = StringUtils.isEmpty((CharSequence)query.getQueryString());
        boolean hasEmptyWhereClause = query.getWhereClause() == null || StringUtils.isEmpty((CharSequence)query.getWhereClause().toString());
        boolean queryIsEmpty = hasEmptyQuery && hasEmptyWhereClause;
        boolean bl = shouldNotSearch = emptyJqlReturnsNoDataEnabled && queryIsEmpty;
        if (logEmptyQueryUsage && queryIsEmpty) {
            this.eventPublisher.publish((Object)new EmptyJqlSearchEvent(shouldNotSearch));
            if (shouldNotSearch) {
                log.debug("Attempt to run an empty query. Returning empty result set.");
            }
        }
        return shouldNotSearch;
    }

    private void search(com.atlassian.query.Query searchQuery, ApplicationUser user, Collector collector, Query andQuery, boolean overrideSecurity) throws SearchException {
        long start = System.currentTimeMillis();
        Query finalQuery = andQuery;
        if (searchQuery.getWhereClause() != null) {
            QueryCreationContextImpl context = new QueryCreationContextImpl(user, overrideSecurity);
            Query query = this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)context, searchQuery.getWhereClause());
            if (query != null) {
                if (finalQuery != null) {
                    BooleanQuery.Builder join = new BooleanQuery.Builder();
                    join.add(finalQuery, BooleanClause.Occur.MUST);
                    join.add(query, BooleanClause.Occur.MUST);
                    finalQuery = join.build();
                } else {
                    finalQuery = query;
                }
                if (log.isDebugEnabled()) {
                    log.debug("JQL query: " + searchQuery.toString());
                    log.debug("JQL lucene query: " + finalQuery);
                }
            } else {
                log.debug("Got a null query from the JQL Query.");
            }
        }
        Query permissionsQuery = this.getPermissionsQuery(overrideSecurity, user, this.getQueryProjects(searchQuery));
        try (Ticker ignored = Timers.start((String)"Searching with Collector");){
            if (finalQuery == null) {
                finalQuery = new MatchAllDocsQuery();
            }
            OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_READS);
            this.getIssueSearcher().search(LuceneSearchProvider.wrapFilterQuery(permissionsQuery, finalQuery), collector);
            long elapsedTime = opTimer.end().getMillisecondsTaken();
            this.publishMetricEvent(searchQuery, finalQuery, elapsedTime, -1, collector.getClass().toString());
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
        ThreadLocalQueryProfiler.store("lucene", (Supplier<String>)((Supplier)() -> ((Query)finalQuery).toString()), System.currentTimeMillis() - start);
    }

    private Query createLuceneQuery(com.atlassian.query.Query searchQuery, Query andQuery, ApplicationUser searchUser, boolean overrideSecurity) throws SearchException {
        String jqlSearchQuery = searchQuery.toString();
        Query finalQuery = andQuery;
        if (searchQuery.getWhereClause() != null) {
            QueryCreationContextImpl context = new QueryCreationContextImpl(searchUser, overrideSecurity);
            Query query = this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)context, searchQuery.getWhereClause());
            if (query != null) {
                log.debug("JQL query: {}", (Object)jqlSearchQuery);
                if (finalQuery != null) {
                    BooleanQuery.Builder join = new BooleanQuery.Builder();
                    join.add(finalQuery, BooleanClause.Occur.MUST);
                    join.add(query, BooleanClause.Occur.MUST);
                    finalQuery = join.build();
                } else {
                    finalQuery = query;
                }
            } else {
                log.debug("Got a null query from the JQL Query.");
            }
        }
        if (finalQuery == null) {
            finalQuery = new MatchAllDocsQuery();
        }
        log.debug("JQL lucene query: {}", (Object)finalQuery);
        return finalQuery;
    }

    /*
     * Exception decompiling
     */
    private SearchResults<DocumentWithId> search(com.atlassian.query.Query query, ApplicationUser searcher, PagerFilter pager, Set<String> fieldsToLoad, Query andQuery, boolean overrideSecurity) throws SearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> ArrayList<T> convertTopDocs(TopDocs luceneMatches, Function<Integer, T> integerDocumentFunction, PagerFilter pager) {
        int end = Math.min(pager.getEnd(), (int)luceneMatches.totalHits);
        return (ArrayList)Arrays.stream(luceneMatches.scoreDocs, pager.getStart(), end).map(scoreDoc -> scoreDoc.doc).map(integerDocumentFunction).collect(CollectorsUtil.toNewArrayListWithCapacity((int)(end - pager.getStart())));
    }

    private DocumentWithId getDocument(Set<String> fieldsToLoad, ManagedIndexSearcher issueSearcher, Integer docId) {
        try {
            Document document = fieldsToLoad != null && fieldsToLoad.isEmpty() ? new Document() : issueSearcher.doc(docId.intValue(), fieldsToLoad);
            return new DocumentWithId(document, docId.intValue());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private Query getPermissionsQuery(boolean overRideSecurity, ApplicationUser searchUser, Collection<Project> projects) {
        if (!overRideSecurity) {
            Optional<Query> filterFromCache = this.permissionQueryCache.getPermissionQuery(searchUser, projects);
            if (filterFromCache.isPresent()) {
                return filterFromCache.get();
            }
            return this.permissionsFilterGenerator.getQuery(searchUser, projects);
        }
        return null;
    }

    static Query wrapFilterQuery(Query filterQuery, Query query) {
        if (filterQuery == null) {
            return query;
        }
        return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
    }

    private TopDocs runSearch(Query query, Query filterQuery, SortField[] sortFields, PagerFilter pager) throws IOException {
        return this.hasLimit(pager) ? this.searchDocuments(query, filterQuery, sortFields, pager.getEnd()) : this.searchDocuments(query, filterQuery, sortFields);
    }

    private TopDocs searchDocuments(Query query, Query filterQuery, SortField[] sortFields, int maxHits) throws IOException {
        ManagedIndexSearcher issueSearcher = this.getIssueSearcher();
        return ArrayUtils.isNotEmpty((Object[])sortFields) ? issueSearcher.search(LuceneSearchProvider.wrapFilterQuery(filterQuery, query), maxHits, new Sort(sortFields)) : issueSearcher.search(LuceneSearchProvider.wrapFilterQuery(filterQuery, query), maxHits);
    }

    private TopDocs searchDocuments(Query query, Query filterQuery, SortField[] sortFields) throws IOException {
        TopDocs hits = this.searchDocuments(query, filterQuery, sortFields, 1000);
        this.eventPublisher.publish((Object)new SearchUnknownResultSizeEvent((int)hits.totalHits));
        if (hits.totalHits <= 1000L) {
            return hits;
        }
        if (hits.totalHits > 100000L && this.isSearchLimited()) {
            String message = String.format("Search for the query [%s] was performed and results count (%d) exceeds max allowed search limit (%d). Large result sets could lead to OutOfMemoryError. If you're sure you need to do the query you can remove the limit by enabling %s feature.", query, hits.totalHits, 100000, RESULTS_LIMIT_DISABLED_FEATURE_KEY);
            log.debug(message, (Throwable)new SearchException(message));
        } else {
            log.debug("Search for the query [{}] was performed and results count ({}) exceeds default limit ({})", new Object[]{query, hits.totalHits, 1000});
        }
        return this.searchDocuments(query, filterQuery, sortFields, (int)hits.totalHits);
    }

    private boolean isSearchLimited() {
        return !this.featureManager.isEnabled(RESULTS_LIMIT_DISABLED_FEATURE_KEY);
    }

    private boolean hasLimit(PagerFilter pager) {
        return pager != null && pager.getEnd() > 0 && pager.getEnd() < Integer.MAX_VALUE;
    }

    private SortField[] getSortFields(ApplicationUser searcher, com.atlassian.query.Query query, boolean overrideSecurity) {
        if (query == null) {
            return null;
        }
        com.atlassian.query.Query queryWithPropertyTyping = this.propertyTypeInfoQueryModifier.addPropertyTypeInfoToQuery(query);
        List sorts = this.searchSortUtil.getSearchSorts(queryWithPropertyTyping);
        ArrayList<SortField> luceneSortFields = new ArrayList<SortField>();
        if (sorts != null) {
            FieldManager fieldManager = ComponentAccessor.getFieldManager();
            for (SearchSort searchSort : sorts) {
                if (searchSort.getProperty().isDefined() && EntityPropertyType.isJqlClause((String)searchSort.getField())) {
                    EntityPropertyType entityPropertyType = EntityPropertyType.getEntityPropertyTypeForClause((String)searchSort.getField());
                    Property property = (Property)searchSort.getProperty().get();
                    luceneSortFields.add(new SortField(entityPropertyType.getIndexPrefix() + "_" + property.getAsPropertyString(), this.getComparatorSourceFromProperty(property), this.getSortOrder(searchSort, null)));
                } else {
                    Collection fieldIdsCollection = overrideSecurity ? this.searchHandlerManager.getFieldIds(searchSort.getField()) : this.searchHandlerManager.getFieldIds(searcher, searchSort.getField());
                    ArrayList fieldIds = new ArrayList(fieldIdsCollection);
                    Collections.sort(fieldIds);
                    for (String fieldId : fieldIds) {
                        if (fieldManager.isNavigableField(fieldId)) {
                            NavigableField field = fieldManager.getNavigableField(fieldId);
                            luceneSortFields.addAll(field.getSortFields(this.getSortOrder(searchSort, field)));
                            continue;
                        }
                        log.debug("Search sort contains invalid field: " + searchSort);
                    }
                }
                if (!this.jqlAliasManager.isJqlAlias(searchSort.getField())) continue;
                Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searchSort.getField());
                clauseHandlers.stream().filter(handler -> handler.getInformation() instanceof AliasClauseInformation).forEach(handler -> {
                    AliasClauseInformation aliasInfo = (AliasClauseInformation)handler.getInformation();
                    String indexField = handler.getInformation().getIndexField();
                    FieldComparatorSource sfComparatorSrc = this.getComparatorSourceFromProperty(aliasInfo.getPropertyAliasedFrom());
                    luceneSortFields.add(new SortField(indexField, sfComparatorSrc, this.getSortOrder(searchSort, null)));
                });
            }
        }
        return luceneSortFields.toArray(new SortField[luceneSortFields.size()]);
    }

    private FieldComparatorSource getComparatorSourceFromProperty(Property prop) {
        if (IndexDocumentConfiguration.Type.DATE.equals((Object)prop.getType())) {
            return new LongSortComparatorSource();
        }
        return new StringSortComparatorSource();
    }

    private boolean getSortOrder(SearchSort searchSort, NavigableField field) {
        boolean order;
        if (searchSort.getOrder() == null) {
            String defaultSortOrder;
            String string = defaultSortOrder = field == null ? "DESC" : field.getDefaultSortOrder();
            order = defaultSortOrder == null ? false : SortOrder.parseString((String)defaultSortOrder) == SortOrder.DESC;
        } else {
            order = searchSort.isReverse();
        }
        return order;
    }

    Collection<Project> getQueryProjects(com.atlassian.query.Query query) {
        if (query == null || query.getWhereClause() == null || !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PER_PROJECT_PERMISSION_QUERY)) {
            return ImmutableList.of();
        }
        try (Ticker ignored = Timers.start((String)"Get Query Projects");){
            Collection collection = this.projectManager.getProjectsByArgs(this.projectsExtractor.extractDeterminedProjectsFromClause(query.getWhereClause()));
            return collection;
        }
    }

    private static /* synthetic */ String lambda$search$1(com.atlassian.query.Query query) {
        return String.valueOf(query);
    }

    private /* synthetic */ DocumentWithId lambda$search$0(Set fieldsToLoad, ManagedIndexSearcher issueSearcher, Integer docId) {
        return this.getDocument(fieldsToLoad, issueSearcher, docId);
    }
}

