/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.search.Query;

public class CachedWrappedQueryCache {
    private final Map cache = new LRUMap(8);

    public Query getQuery(ApplicationUser user, Collection<Project> projects) {
        return (Query)this.cache.get(new WFCacheKey(user, projects));
    }

    public void storeQuery(Query query, ApplicationUser user, Collection<Project> projects) {
        this.cache.put(new WFCacheKey(user, projects), query);
    }

    private static class WFCacheKey {
        String username;
        Collection<Long> projectIds;

        public WFCacheKey(ApplicationUser searcher, Collection<Project> projects) {
            if (searcher != null) {
                this.username = searcher.getName();
            }
            if (projects != null) {
                this.projectIds = projects.stream().map(Project::getId).collect(Collectors.toList());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WFCacheKey that = (WFCacheKey)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.projectIds, that.projectIds);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.projectIds);
        }
    }
}

