/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

public class LuceneQueryMetrics {
    public Map<String, Integer> numberOfClausesPerField(Query query) {
        HashMap<String, Integer> groupBy = new HashMap<String, Integer>();
        this.groupByTermCount(query, groupBy);
        return groupBy;
    }

    private void groupByTermCount(Query query, Map<String, Integer> groupBy) {
        if (query instanceof TermQuery) {
            this.increaseTermCount(groupBy, ((TermQuery)query).getTerm());
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                this.groupByTermCount(clause.getQuery(), groupBy);
            }
        } else if (query instanceof PhraseQuery) {
            for (Term term : ((PhraseQuery)query).getTerms()) {
                this.increaseTermCount(groupBy, term);
            }
        } else if (query instanceof FuzzyQuery) {
            this.increaseTermCount(groupBy, ((FuzzyQuery)query).getTerm());
        } else if (query instanceof TermRangeQuery) {
            this.increaseTermCount(groupBy, ((TermRangeQuery)query).getField());
        } else if (query instanceof PrefixQuery) {
            this.increaseTermCount(groupBy, ((PrefixQuery)query).getPrefix());
        } else if (query instanceof WildcardQuery) {
            this.increaseTermCount(groupBy, ((WildcardQuery)query).getTerm());
        } else {
            this.increaseTermCount(groupBy, query.getClass().getName());
        }
    }

    private void increaseTermCount(Map<String, Integer> groupBy, Term term) {
        this.increaseTermCount(groupBy, term.field());
    }

    private void increaseTermCount(Map<String, Integer> groupBy, String field) {
        groupBy.put(field, groupBy.getOrDefault(field, 0) + 1);
    }
}

