/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.metrics;

import com.atlassian.jira.event.MetricEvent;
import com.atlassian.query.Query;
import java.util.Map;
import java.util.Objects;

public class LuceneQueryExecutionEvent
implements MetricEvent {
    private final Query query;
    private final Map<String, Integer> numberOfClausesPerField;
    private final long numberOfClausesInQuery;
    private final long executionTime;
    private final int numberOfResults;
    private final String collectorType;
    public static final int NUMBER_OF_RESULTS_UNKNOWN = -1;

    public LuceneQueryExecutionEvent(Query query, Map<String, Integer> numberOfClausesPerField, long executionTime, int numberOfResults, String collectorType) {
        this.query = query;
        this.numberOfClausesPerField = numberOfClausesPerField;
        this.numberOfClausesInQuery = this.sumNumberOfClauses(numberOfClausesPerField);
        this.executionTime = executionTime;
        this.numberOfResults = numberOfResults;
        this.collectorType = collectorType;
    }

    private int sumNumberOfClauses(Map<String, Integer> numberOfClausesPerField) {
        return numberOfClausesPerField.values().stream().filter(Objects::nonNull).mapToInt(v -> v).sum();
    }

    public Query getQuery() {
        return this.query;
    }

    public long getNumberOfClausesInQuery() {
        return this.numberOfClausesInQuery;
    }

    public Map<String, Integer> getNumberOfClausesPerField() {
        return this.numberOfClausesPerField;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public String getCollectorType() {
        return this.collectorType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQueryExecutionEvent that = (LuceneQueryExecutionEvent)o;
        return this.numberOfClausesInQuery == that.numberOfClausesInQuery && this.executionTime == that.executionTime && this.numberOfResults == that.numberOfResults && Objects.equals(this.query, that.query) && Objects.equals(this.collectorType, that.collectorType);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.numberOfClausesInQuery, this.executionTime, this.numberOfResults, this.collectorType);
    }

    public String toString() {
        return "LuceneQueryExecutionEvent{query=" + this.query + ", numberOfClausesPerField=" + this.numberOfClausesPerField + ", numberOfClausesInQuery=" + this.numberOfClausesInQuery + ", executionTime=" + this.executionTime + ", numberOfResults=" + this.numberOfResults + ", collectorType='" + this.collectorType + '\'' + '}';
    }

    public String toMetrics() {
        return "LuceneQueryExecutionEvent{numberOfClausesPerField=" + this.numberOfClausesPerField + ", numberOfClausesInQuery=" + this.numberOfClausesInQuery + ", executionTime=" + this.executionTime + ", numberOfResults=" + this.numberOfResults + ", collectorType='" + this.collectorType + '\'' + '}';
    }

    public String getName() {
        return LuceneQueryExecutionEvent.class.getName();
    }
}

