/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.managers;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.index.property.JqlAlias;
import com.atlassian.jira.index.property.JqlAliasManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.SystemClauseHandlerFactory;
import com.atlassian.jira.issue.search.handlers.TextQuerySearchHandlerFactory;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherComparatorFactory;
import com.atlassian.jira.issue.search.searchers.SearcherGroup;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.plugin.JiraPluginTransactionEndEvent;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.index.EntityPropertyIndexDocumentModuleDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.IdentitySet;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@ThreadSafe
public final class DefaultSearchHandlerManager
implements SearchHandlerManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchHandlerManager.class);
    private final FieldManager fieldManager;
    private final CustomFieldManager customFieldManager;
    private final SystemClauseHandlerFactory systemClauseHandlerFactory;
    private final QueryCache queryCache;
    private final JqlAliasManager jqlAliasManager;
    private final CachedReference<Helper> helperResettableLazyReference;
    static final Function<ClauseHandler, String> getFieldId = new Function<ClauseHandler, String>(){

        public String apply(ClauseHandler handler) {
            return handler.getInformation().getFieldId();
        }
    };
    static final Predicate<ClauseHandler> hasFieldId = new Predicate<ClauseHandler>(){

        public boolean apply(ClauseHandler clauseHandler) {
            return getFieldId.apply((Object)clauseHandler) != null;
        }
    };
    static final Function<ClauseHandler, ClauseNames> getClauseNames = new Function<ClauseHandler, ClauseNames>(){

        public ClauseNames apply(ClauseHandler clauseHandler) {
            return clauseHandler.getInformation().getJqlClauseNames();
        }
    };

    public DefaultSearchHandlerManager(FieldManager fieldManager, CustomFieldManager customFieldManager, SystemClauseHandlerFactory systemClauseHandlerFactory, QueryCache queryCache, CacheManager cacheManager, JqlAliasManager jqlAliasManager) {
        this.queryCache = queryCache;
        this.jqlAliasManager = jqlAliasManager;
        this.systemClauseHandlerFactory = (SystemClauseHandlerFactory)Assertions.notNull((String)"systemClauseHandlerFactory", (Object)systemClauseHandlerFactory);
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((String)"customFieldManager", (Object)customFieldManager);
        this.helperResettableLazyReference = cacheManager.getCachedReference(DefaultSearchHandlerManager.class, "helperResettableLazyReference", (Supplier)new Supplier<Helper>(){

            public Helper get() {
                return DefaultSearchHandlerManager.this.createHelper();
            }
        });
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @EventListener
    public void onJiraPluginTransactionEndEvent(JiraPluginTransactionEndEvent event) {
        if (event.hasAnyEventWithModuleDescriptorMatching(moduleDescriptor -> CustomFieldSearcherModuleDescriptor.class.isInstance(moduleDescriptor) || EntityPropertyIndexDocumentModuleDescriptor.class.isInstance(moduleDescriptor))) {
            this.refresh();
        }
    }

    @Nonnull
    public Collection<ClauseHandler> getClauseHandler(ApplicationUser user, String jqlClauseName) {
        Collection<Object> clauseHandler = this.queryCache.getClauseHandlers(user, jqlClauseName);
        if (clauseHandler == null) {
            ArrayList<ClauseHandler> filteredHandlers = new ArrayList<ClauseHandler>();
            Collection<ClauseHandler> unfilteredHandlers = this.getClauseHandler(jqlClauseName);
            for (ClauseHandler handler : unfilteredHandlers) {
                if (!handler.getPermissionHandler().hasPermissionToUseClause(user)) continue;
                filteredHandlers.add(handler);
            }
            clauseHandler = Collections.unmodifiableCollection(filteredHandlers);
            this.queryCache.setClauseHandlers(user, jqlClauseName, clauseHandler);
        }
        return clauseHandler;
    }

    @Nonnull
    public Collection<ClauseHandler> getClauseHandler(String jqlClauseName) {
        Assertions.notBlank((String)"jqlClauseName", (String)jqlClauseName);
        return Collections.unmodifiableCollection(this.getHelper().getSearchHandler(jqlClauseName));
    }

    @Nonnull
    public Collection<ClauseNames> getJqlClauseNames(String fieldId) {
        Assertions.notBlank((String)"fieldId", (String)fieldId);
        return DefaultSearchHandlerManager.returnNullAsEmpty(this.getHelper().getJqlClauseNames(fieldId));
    }

    @Nonnull
    public Collection<ClauseNames> getVisibleJqlClauseNames(ApplicationUser searcher) {
        return CollectionUtil.transformSet((Iterable)Iterables.filter(this.getHelper().getSearchHandlers(), (Predicate)new PermissionToUse(searcher)), getClauseNames);
    }

    @Nonnull
    public Collection<ClauseHandler> getVisibleClauseHandlers(ApplicationUser searcher) {
        HashSet<ClauseHandler> visibleClauseHandlers = new HashSet<ClauseHandler>();
        Collection<ClauseHandler> clauseHandlers = this.getHelper().getSearchHandlers();
        Set fieldLayouts = this.fieldManager.getVisibleFieldLayouts(searcher);
        for (ClauseHandler clauseHandler : clauseHandlers) {
            if (!clauseHandler.getPermissionHandler().hasPermissionToUseClause(searcher, fieldLayouts)) continue;
            visibleClauseHandlers.add(clauseHandler);
        }
        return visibleClauseHandlers;
    }

    @Nonnull
    public Collection<String> getFieldIds(ApplicationUser searcher, String jqlClauseName) {
        return CollectionUtil.transform((Iterable)Iterables.filter(this.getHelper().getSearchHandler(jqlClauseName), (Predicate)Predicates.and(hasFieldId, (Predicate)new PermissionToUse(searcher))), getFieldId);
    }

    @Nonnull
    public Collection<String> getFieldIds(String jqlClauseName) {
        return CollectionUtil.transform((Iterable)Iterables.filter(this.getHelper().getSearchHandler(jqlClauseName), hasFieldId), getFieldId);
    }

    @Nonnull
    public Collection<IssueSearcher<?>> getSearchersByClauseName(ApplicationUser user, String jqlClauseName, SearchContext searchContext) {
        return this.getSearchersByClauseName(user, jqlClauseName);
    }

    @Nonnull
    public Collection<IssueSearcher<?>> getSearchersByClauseName(ApplicationUser user, String jqlClauseName) {
        Assertions.notBlank((String)"jqlClauseName", (String)jqlClauseName);
        return CollectionUtil.toList((Iterable)Iterables.filter((Iterable)CollectionUtil.transform(this.getHelper().getIssueSearcherRegistrationsByClauseName(jqlClauseName), (Function)new Function<SearchHandler.SearcherRegistration, IssueSearcher<?>>(){

            public IssueSearcher<?> apply(SearchHandler.SearcherRegistration searcherRegistration) {
                return searcherRegistration.getIssueSearcher();
            }
        }), (Predicate)Predicates.notNull()));
    }

    public Collection<IssueSearcher<?>> getSearchers(ApplicationUser searcher, SearchContext context) {
        Assertions.notNull((String)"context", (Object)context);
        context.verify();
        return CollectionUtil.toList((Iterable)Iterables.filter(this.getAllSearchers(), (Predicate)new IsShown(searcher, context)));
    }

    public Collection<IssueSearcher<?>> getAllSearchers() {
        return DefaultSearchHandlerManager.returnNullAsEmpty(this.getHelper().getAllIssueSearchers());
    }

    public Collection<SearcherGroup> getSearcherGroups(SearchContext searchContext) {
        return this.getSearcherGroups();
    }

    public Collection<SearcherGroup> getSearcherGroups() {
        return DefaultSearchHandlerManager.returnNullAsEmpty(this.getHelper().getSearcherGroups());
    }

    public IssueSearcher<?> getSearcher(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.getHelper().getIssueSearcher(id);
    }

    private Helper getHelper() {
        return (Helper)this.helperResettableLazyReference.get();
    }

    private Helper createHelper() {
        SearchHandlerIndexer indexer = new SearchHandlerIndexer();
        Set allSearchableFields = this.fieldManager.getSystemSearchableFields();
        for (SearchableField field : allSearchableFields) {
            indexer.indexSystemField(field);
        }
        TextQuerySearchHandlerFactory textQuerySearchHandlerFactory = (TextQuerySearchHandlerFactory)ComponentAccessor.getComponent(TextQuerySearchHandlerFactory.class);
        if (textQuerySearchHandlerFactory != null) {
            indexer.indexSearchHandler(null, textQuerySearchHandlerFactory.createHandler(), true);
        }
        indexer.indexSystemClauseHandlers(this.systemClauseHandlerFactory.getSystemClauseSearchHandlers());
        List customField = this.customFieldManager.getCustomFieldObjects();
        for (CustomField field : customField) {
            indexer.indexCustomField(field);
        }
        for (JqlAlias jqlAlias : this.jqlAliasManager.getJqlAliases()) {
            indexer.indexJqlPropertyAlias(jqlAlias);
        }
        return new Helper(indexer);
    }

    public void refresh() {
        this.helperResettableLazyReference.reset();
    }

    private static <T> Collection<T> returnNullAsEmpty(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    static class IsShown
    implements Predicate<IssueSearcher<?>> {
        private final ApplicationUser user;
        private final SearchContext context;

        public IsShown(ApplicationUser user, SearchContext context) {
            this.user = user;
            this.context = context;
        }

        public boolean apply(IssueSearcher<?> issueSearcher) {
            return issueSearcher.getSearchRenderer().isShown(this.user, this.context);
        }
    }

    static class PermissionToUse
    implements Predicate<ClauseHandler> {
        private final ApplicationUser user;

        PermissionToUse(ApplicationUser user) {
            this.user = user;
        }

        public boolean evaluate(ClauseHandler clauseHandler) {
            return clauseHandler.getPermissionHandler().hasPermissionToUseClause(this.user);
        }

        public boolean apply(ClauseHandler clauseHandler) {
            return clauseHandler.getPermissionHandler().hasPermissionToUseClause(this.user);
        }
    }

    @NotThreadSafe
    private static class SearchHandlerIndexer {
        private final Set<String> systemClauses = new HashSet<String>();
        private final Map<String, Set<ClauseHandler>> handlerIndex = new HashMap<String, Set<ClauseHandler>>();
        private final Map<String, Set<SearchHandler.SearcherRegistration>> searcherClauseNameIndex = new LinkedHashMap<String, Set<SearchHandler.SearcherRegistration>>();
        private final Map<String, IssueSearcher<?>> searcherIdIndex = new LinkedHashMap();
        private final Map<SearcherGroupType, Set<IssueSearcher<?>>> groupIndex = new EnumMap(SearcherGroupType.class);

        SearchHandlerIndexer() {
            for (SearcherGroupType groupType : SearcherGroupType.values()) {
                this.groupIndex.put(groupType, IdentitySet.newListOrderedSet());
            }
        }

        Map<String, List<ClauseNames>> createFieldToClauseNamesIndex() {
            HashMap<String, ArrayList<ClauseNames>> fieldToClauseNames = new HashMap<String, ArrayList<ClauseNames>>();
            for (Set<ClauseHandler> handlers : this.handlerIndex.values()) {
                for (ClauseHandler handler : handlers) {
                    ClauseInformation information = handler.getInformation();
                    if (information.getFieldId() == null) continue;
                    ArrayList<ClauseNames> names = (ArrayList<ClauseNames>)fieldToClauseNames.get(information.getFieldId());
                    if (names == null) {
                        names = new ArrayList<ClauseNames>();
                        fieldToClauseNames.put(information.getFieldId(), names);
                    }
                    names.add(information.getJqlClauseNames());
                }
            }
            HashMap returnMe = new HashMap();
            for (Map.Entry entry : fieldToClauseNames.entrySet()) {
                returnMe.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
            return Collections.unmodifiableMap(returnMe);
        }

        Map<String, List<ClauseHandler>> createHandlerIndex() {
            HashMap<String, List> tmpHandlerIndex = new HashMap<String, List>();
            for (Map.Entry<String, Set<ClauseHandler>> entry : this.handlerIndex.entrySet()) {
                tmpHandlerIndex.put(entry.getKey(), CollectionUtil.copyAsImmutableList((Collection)entry.getValue()));
            }
            return Collections.unmodifiableMap(tmpHandlerIndex);
        }

        Map<String, List<SearchHandler.SearcherRegistration>> createSearcherJqlNameIndex() {
            HashMap<String, List> tmpHandlerIndex = new HashMap<String, List>();
            for (Map.Entry<String, Set<SearchHandler.SearcherRegistration>> entry : this.searcherClauseNameIndex.entrySet()) {
                tmpHandlerIndex.put(entry.getKey(), CollectionUtil.copyAsImmutableList((Collection)entry.getValue()));
            }
            return Collections.unmodifiableMap(tmpHandlerIndex);
        }

        List<SearcherGroup> createSearcherGroups() {
            Set<Map.Entry<SearcherGroupType, Set<IssueSearcher<?>>>> entries = this.groupIndex.entrySet();
            ArrayList<SearcherGroup> groups = new ArrayList<SearcherGroup>(entries.size());
            for (Map.Entry<SearcherGroupType, Set<IssueSearcher<?>>> entry : entries) {
                if (!entry.getValue().isEmpty()) {
                    ArrayList searcher = new ArrayList(entry.getValue());
                    Collections.sort(searcher, SearcherComparatorFactory.getSearcherComparator(entry.getKey()));
                    groups.add(new SearcherGroup(entry.getKey(), searcher));
                    continue;
                }
                groups.add(new SearcherGroup(entry.getKey(), Collections.emptyList()));
            }
            return Collections.unmodifiableList(groups);
        }

        Map<String, IssueSearcher<?>> createSearcherIdIndex() {
            return Collections.unmodifiableMap(new LinkedHashMap(this.searcherIdIndex));
        }

        void indexSystemField(SearchableField systemField) {
            this.indexSearchableField(systemField, true);
        }

        public void indexCustomField(CustomField customField) {
            this.indexSearchableField((SearchableField)customField, false);
        }

        public void indexSystemClauseHandlers(Collection<SearchHandler> searchHandlers) {
            for (SearchHandler searchHandler : searchHandlers) {
                this.indexClauseHandlers(null, searchHandler.getClauseRegistrations(), true);
            }
        }

        public void indexJqlPropertyAlias(JqlAlias jqlAlias) {
            ClauseNames jqlClauseNames = jqlAlias.getClauseHandler().getInformation().getJqlClauseNames();
            for (String jqlName : jqlClauseNames.getJqlFieldNames()) {
                this.register(CaseFolding.foldString((String)jqlName), new SearchHandler.ClauseRegistration(jqlAlias.getClauseHandler()));
            }
        }

        private void indexSearchableField(SearchableField field, boolean system) {
            SearchHandler searchHandler = field.createAssociatedSearchHandler();
            if (searchHandler != null) {
                this.indexSearchHandler(field, searchHandler, system);
            } else if (log.isDebugEnabled()) {
                log.debug("Searchable field '" + field.getId() + "' does not have a search handler, will not be searchable.");
            }
        }

        private void indexSearchHandler(SearchableField field, SearchHandler handler, boolean system) {
            SearchHandler.SearcherRegistration registration = handler.getSearcherRegistration();
            if (registration != null) {
                this.indexSearcherById(field, registration.getIssueSearcher(), system);
                this.indexClauseHandlers(field, registration.getClauseHandlers(), system);
                this.indexSearcherByJqlName(field, registration, system);
            }
            this.indexClauseHandlers(field, handler.getClauseRegistrations(), system);
        }

        private void indexClauseHandlers(SearchableField field, Collection<? extends SearchHandler.ClauseRegistration> clauseHandlers, boolean system) {
            for (SearchHandler.ClauseRegistration clauseRegistration : clauseHandlers) {
                this.indexClauseHandlerByJqlName((Field)field, clauseRegistration, system);
            }
        }

        private void indexClauseHandlerByJqlName(Field field, SearchHandler.ClauseRegistration registration, boolean system) {
            Set names = ((ClauseNames)getClauseNames.apply((Object)registration.getHandler())).getJqlFieldNames();
            for (String name : names) {
                if (this.systemClauses.contains(name = CaseFolding.foldString((String)name))) {
                    if (system) {
                        if (field != null) {
                            throw new RuntimeException(String.format("Two system clauses are trying to register against the same JQL name. New Field = '%s', Jql Name = '%s'.", field.getName(), name));
                        }
                        throw new RuntimeException(String.format("Two system clauses are trying to register against the same JQL name. Clause with Jql Name = '%s'.", name));
                    }
                    CustomFieldType type = ((CustomField)field).getCustomFieldType();
                    String typeName = type != null ? type.getName() : "Unknown Type";
                    log.warn(String.format("A custom field '%s (%s)' is trying to register a clause handler against a system clause with name '%s'. Ignoring request.", field.getName(), typeName, name));
                    continue;
                }
                if (system) {
                    this.systemClauses.add(name);
                }
                this.register(name, registration);
            }
        }

        private void indexSearcherByJqlName(SearchableField field, SearchHandler.SearcherRegistration searcherRegistration, boolean system) {
            for (SearchHandler.ClauseRegistration clauseRegistration : searcherRegistration.getClauseHandlers()) {
                for (String name : ((ClauseNames)getClauseNames.apply((Object)clauseRegistration.getHandler())).getJqlFieldNames()) {
                    name = CaseFolding.foldString((String)name);
                    if (!system && this.systemClauses.contains(name)) {
                        CustomFieldType type = ((CustomField)field).getCustomFieldType();
                        String typeName = type != null ? type.getName() : "Unknown Type";
                        log.warn(String.format("A custom field '%s (%s)' is trying to register a searcher against a system clause with name '%s'. Ignoring request.", field.getName(), typeName, name));
                        continue;
                    }
                    this.register(name, searcherRegistration);
                }
            }
        }

        private void register(String name, SearchHandler.ClauseRegistration registration) {
            Set<ClauseHandler> currentHandlers = this.handlerIndex.get(name);
            if (currentHandlers == null) {
                currentHandlers = IdentitySet.newListOrderedSet();
                currentHandlers.add(registration.getHandler());
                this.handlerIndex.put(name, currentHandlers);
            } else {
                currentHandlers.add(registration.getHandler());
            }
        }

        private void register(String name, SearchHandler.SearcherRegistration searcherRegistration) {
            Set<SearchHandler.SearcherRegistration> currentSearcherRegistrations = this.searcherClauseNameIndex.get(name);
            if (currentSearcherRegistrations == null) {
                currentSearcherRegistrations = IdentitySet.newListOrderedSet();
                currentSearcherRegistrations.add(searcherRegistration);
                this.searcherClauseNameIndex.put(name, currentSearcherRegistrations);
            } else {
                currentSearcherRegistrations.add(searcherRegistration);
            }
        }

        private void indexSearcherById(SearchableField field, IssueSearcher<?> newSearcher, boolean system) {
            if (newSearcher == null) {
                return;
            }
            String searcherId = newSearcher.getSearchInformation().getId();
            IssueSearcher<?> currentSearcher = this.searcherIdIndex.get(searcherId);
            if (currentSearcher != null) {
                if (currentSearcher != newSearcher) {
                    log.debug(String.format("Trying to register two searchers to the same id. Field = '%s', Current searcher = '%s', New Searcher = '%s', SearcherId ='%s'.", field.getName(), currentSearcher, newSearcher, searcherId));
                }
            } else {
                SearcherGroupType type;
                this.searcherIdIndex.put(searcherId, newSearcher);
                if (system) {
                    type = newSearcher.getSearchInformation().getSearcherGroupType();
                    if (type == null) {
                        log.warn(String.format("System field '%s' does not have a group type registered. Placing in %s group.", field.getName(), SearcherGroupType.CUSTOM));
                        type = SearcherGroupType.CUSTOM;
                    }
                } else {
                    SearcherGroupType givenType = newSearcher.getSearchInformation().getSearcherGroupType();
                    if (givenType != null && givenType != SearcherGroupType.CUSTOM) {
                        CustomFieldType cfType = ((CustomField)field).getCustomFieldType();
                        String typeName = cfType != null ? cfType.getName() : "Unknown Type";
                        log.warn(String.format("Custom field '%s (%s)' is trying to register itself in the '%s' group.", field.getName(), typeName, givenType));
                    }
                    type = SearcherGroupType.CUSTOM;
                }
                this.groupIndex.get(type).add(newSearcher);
            }
        }
    }

    @ThreadSafe
    static class Helper {
        private final Map<String, List<ClauseHandler>> handlerIndex;
        private final Map<String, IssueSearcher<?>> searcherIndex;
        private final Map<String, List<SearchHandler.SearcherRegistration>> searcherClauseNameIndex;
        private final Map<String, List<ClauseNames>> fieldIdToClauseNames;
        private final List<SearcherGroup> searcherGroup;

        public Helper(SearchHandlerIndexer indexer) {
            this.searcherIndex = indexer.createSearcherIdIndex();
            this.handlerIndex = indexer.createHandlerIndex();
            this.searcherGroup = indexer.createSearcherGroups();
            this.searcherClauseNameIndex = indexer.createSearcherJqlNameIndex();
            this.fieldIdToClauseNames = indexer.createFieldToClauseNamesIndex();
        }

        public Collection<ClauseHandler> getSearchHandler(String jqlName) {
            return DefaultSearchHandlerManager.returnNullAsEmpty(this.handlerIndex.get(CaseFolding.foldString((String)jqlName)));
        }

        public Collection<ClauseHandler> getSearchHandlers() {
            HashSet<ClauseHandler> allHandlers = new HashSet<ClauseHandler>();
            Collection<List<ClauseHandler>> handlersList = this.handlerIndex.values();
            for (List<ClauseHandler> clauseHandlers : handlersList) {
                allHandlers.addAll(clauseHandlers);
            }
            return allHandlers;
        }

        public IssueSearcher<?> getIssueSearcher(String searcher) {
            return this.searcherIndex.get(searcher);
        }

        public Collection<IssueSearcher<?>> getAllIssueSearchers() {
            return this.searcherIndex.values();
        }

        public Collection<SearchHandler.SearcherRegistration> getIssueSearcherRegistrationsByClauseName(String jqlName) {
            return DefaultSearchHandlerManager.returnNullAsEmpty(this.searcherClauseNameIndex.get(CaseFolding.foldString((String)jqlName)));
        }

        public List<SearcherGroup> getSearcherGroups() {
            return this.searcherGroup;
        }

        public List<ClauseNames> getJqlClauseNames(String fieldId) {
            return this.fieldIdToClauseNames.get(fieldId);
        }
    }
}

