/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.jql;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.user.UserPropertyService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.search.jql.LastJqlFieldsService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastJqlFieldsServiceImpl
implements LastJqlFieldsService {
    public static final Logger log = LoggerFactory.getLogger(LastJqlFieldsServiceImpl.class);
    public static final int MAX_SIZE = 15;
    public static final String JQL_VALUES = "jqlValues";
    private final UserPropertyService userPropertyService;
    private final FeatureManager featureManager;

    public LastJqlFieldsServiceImpl(UserPropertyService userPropertyService, FeatureManager featureManager) {
        this.userPropertyService = userPropertyService;
        this.featureManager = featureManager;
    }

    @Override
    public String getLastFields(ApplicationUser user) {
        if (user != null) {
            EntityPropertyService.PropertyResult jqlValues = this.userPropertyService.getProperty(user, user.getId(), JQL_VALUES);
            if (!jqlValues.getErrorCollection().hasAnyErrors()) {
                return (String)jqlValues.getEntityProperty().map(EntityProperty::getValue).getOrElse((Object)"[]");
            }
            log.error("Error while getting last jqlValues: {}", (Object)jqlValues.getErrorCollection().getErrorMessages());
        }
        return "[]";
    }

    private List<String> getLastFieldsAsList(ApplicationUser user) throws JSONException {
        String json = this.getLastFields(user);
        JSONArray array = new JSONArray(json);
        ArrayList<String> result = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            result.add(array.getString(i));
        }
        return result;
    }

    @Override
    public void addOneField(ApplicationUser user, String field) throws JSONException {
        this.addSomeFields(user, Collections.singleton(field));
    }

    @Override
    public void addSomeFields(ApplicationUser user, Collection<String> fields) throws JSONException {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.JQL_SUGGEST_RECENT_FILDS_FEATURE)) {
            return;
        }
        List<String> toSave = this.addNewFieldsToRecentList(fields, this.getLastFieldsAsList(user));
        String propertyValue = new JSONArray(toSave).toString();
        EntityPropertyService.SetPropertyValidationResult setValidationResult = this.userPropertyService.validateSetProperty(user, user.getId(), new EntityPropertyService.PropertyInput(propertyValue, JQL_VALUES));
        this.userPropertyService.setProperty(user, setValidationResult);
    }

    private List<String> addNewFieldsToRecentList(Collection<String> fields, List<String> storedOperands) {
        storedOperands.removeAll(fields);
        storedOperands.addAll(0, fields);
        return storedOperands.subList(0, Math.min(storedOperands.size(), 15));
    }
}

