/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.indexers.impl.AttachmentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CurrentEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueIdIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueKeyIndexer;
import com.atlassian.jira.issue.index.indexers.impl.OriginalEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ParentIssueIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SecurityIndexer;
import com.atlassian.jira.issue.index.indexers.impl.TimeSpentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VoterIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WatcherIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.SearchHandlerBuilderFactory;
import com.atlassian.jira.issue.search.SystemClauseHandlerFactory;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.IssueIdClauseContextFactory;
import com.atlassian.jira.jql.context.IssueParentClauseContextFactory;
import com.atlassian.jira.jql.context.IssueSecurityLevelClauseContextFactory;
import com.atlassian.jira.jql.context.MultiClauseDecoratorContextFactory;
import com.atlassian.jira.jql.context.ProjectCategoryClauseContextFactory;
import com.atlassian.jira.jql.context.SavedFilterClauseContextFactory;
import com.atlassian.jira.jql.context.ValidatingDecoratorContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.IssueClauseValueSanitiser;
import com.atlassian.jira.jql.permission.IssueParentPermissionChecker;
import com.atlassian.jira.jql.permission.IssuePropertyClausePermissionChecker;
import com.atlassian.jira.jql.permission.StatusCategoryPermissionChecker;
import com.atlassian.jira.jql.permission.TimeTrackingPermissionChecker;
import com.atlassian.jira.jql.permission.VotePermissionChecker;
import com.atlassian.jira.jql.permission.WatchPermissionChecker;
import com.atlassian.jira.jql.query.AttachmentClauseQueryFactory;
import com.atlassian.jira.jql.query.CurrentEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueIdClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueParentClauseQueryFactory;
import com.atlassian.jira.jql.query.IssuePropertyClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueSecurityLevelClauseQueryFactory;
import com.atlassian.jira.jql.query.LastViewedDateClauseQueryFactory;
import com.atlassian.jira.jql.query.OriginalEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.ProjectCategoryClauseQueryFactory;
import com.atlassian.jira.jql.query.SavedFilterClauseQueryFactory;
import com.atlassian.jira.jql.query.StatusCategoryClauseQueryFactory;
import com.atlassian.jira.jql.query.TimeSpentClauseQueryFactory;
import com.atlassian.jira.jql.query.VoterClauseQueryFactory;
import com.atlassian.jira.jql.query.VotesClauseQueryFactory;
import com.atlassian.jira.jql.query.WatcherClauseQueryFactory;
import com.atlassian.jira.jql.query.WatchesClauseQueryFactory;
import com.atlassian.jira.jql.query.WorklogAuthorClauseQueryFactory;
import com.atlassian.jira.jql.query.WorklogCommentClauseQueryFactory;
import com.atlassian.jira.jql.query.WorklogDateClauseQueryFactory;
import com.atlassian.jira.jql.validator.AttachmentsClauseValidator;
import com.atlassian.jira.jql.validator.CurrentEstimateValidator;
import com.atlassian.jira.jql.validator.DescriptionValidator;
import com.atlassian.jira.jql.validator.IssueIdValidator;
import com.atlassian.jira.jql.validator.IssueParentValidator;
import com.atlassian.jira.jql.validator.IssuePropertyClauseValidator;
import com.atlassian.jira.jql.validator.IssueSecurityLevelClauseValidator;
import com.atlassian.jira.jql.validator.LastViewedDateValidator;
import com.atlassian.jira.jql.validator.LocalDateValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.validator.OriginalEstimateValidator;
import com.atlassian.jira.jql.validator.ProjectCategoryValidator;
import com.atlassian.jira.jql.validator.SavedFilterClauseValidator;
import com.atlassian.jira.jql.validator.StatusCategoryValidator;
import com.atlassian.jira.jql.validator.TimeSpentValidator;
import com.atlassian.jira.jql.validator.UserCustomFieldValidator;
import com.atlassian.jira.jql.validator.VotesValidator;
import com.atlassian.jira.jql.validator.WatchesValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.ProjectCategoryClauseValuesGenerator;
import com.atlassian.jira.jql.values.SavedFilterValuesGenerator;
import com.atlassian.jira.jql.values.SecurityLevelClauseValuesGenerator;
import com.atlassian.jira.jql.values.StatusCategoryClauseValuesGenerator;
import com.atlassian.jira.jql.values.UserClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Collections;

public class DefaultSystemClauseHandlerFactory
implements SystemClauseHandlerFactory {
    private final ComponentLocator locator;
    private final ComponentFactory factory;
    private final FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory;
    private final SearchHandlerBuilderFactory searchHandlers;
    private final LazyReference<Collection<SearchHandler>> systemClauseSearchHandlers = new LazyReference<Collection<SearchHandler>>(){

        protected Collection<SearchHandler> create() throws Exception {
            return ImmutableList.of((Object)DefaultSystemClauseHandlerFactory.this.createSavedFilterSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createIssueKeySearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createIssueParentSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createCurrentEstimateSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createOriginalEstimateSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createTimeSpentSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createSecurityLevelSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createVotesSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createVoterSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createWatchesSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createWatcherSearchHandler(), (Object)DefaultSystemClauseHandlerFactory.this.createProjectCategoryHandler(), (Object[])new SearchHandler[]{DefaultSystemClauseHandlerFactory.this.createSubTaskSearchHandler(), DefaultSystemClauseHandlerFactory.this.createProgressSearchHandler(), DefaultSystemClauseHandlerFactory.this.createLastViewedHandler(), DefaultSystemClauseHandlerFactory.this.createAttachmentsSearchHandler(), DefaultSystemClauseHandlerFactory.this.createIssuePropertySearchHandler(), DefaultSystemClauseHandlerFactory.this.createStatusCategorySearchHandler(), DefaultSystemClauseHandlerFactory.this.createWorklogDateSearchHandler(), DefaultSystemClauseHandlerFactory.this.createWorklogAuthorSearchHandler(), DefaultSystemClauseHandlerFactory.this.createWorklogCommentSearchHandler()});
        }
    };

    public DefaultSystemClauseHandlerFactory(ComponentLocator locator, ComponentFactory factory, FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory, SearchHandlerBuilderFactory searchHandlers) {
        this.factory = (ComponentFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.locator = (ComponentLocator)Assertions.notNull((String)"locator", (Object)locator);
        this.fieldClausePermissionHandlerFactory = (FieldClausePermissionChecker.Factory)Assertions.notNull((String)"fieldClausePermissionHandlerFactory", (Object)fieldClausePermissionHandlerFactory);
        this.searchHandlers = searchHandlers;
    }

    @Override
    public Collection<SearchHandler> getSystemClauseSearchHandlers() {
        return (Collection)this.systemClauseSearchHandlers.get();
    }

    private SearchHandler createSavedFilterSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forSavedFilter()).setClauseQueryFactoryType(SavedFilterClauseQueryFactory.class).setClauseValidatorType(SavedFilterClauseValidator.class).setContextFactory(this.decorateWithValidatingContextFactory((ClauseContextFactory)this.locator.getComponentInstanceOfType(SavedFilterClauseContextFactory.class))).setPermissionHandler(DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER).buildWithValuesGenerator(new SavedFilterValuesGenerator((SearchRequestService)this.locator.getComponentInstanceOfType(SearchRequestService.class)));
    }

    private SearchHandler createIssueKeySearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forIssueKey()).setClauseQueryFactoryType(IssueIdClauseQueryFactory.class).setClauseValidatorType(IssueIdValidator.class).setContextFactory(this.decorateWithMultiContextFactory(((IssueIdClauseContextFactory.Factory)this.locator.getComponentInstanceOfType(IssueIdClauseContextFactory.Factory.class)).create(SystemSearchConstants.forIssueKey().getSupportedOperators()))).setPermissionHandler(new DefaultClausePermissionHandler(this.factory.createObject(IssueClauseValueSanitiser.class, new Object[0]))).addIndexer(this.factory.createObject(IssueKeyIndexer.class, new Object[0])).addIndexer(this.factory.createObject(IssueIdIndexer.class, new Object[0])).build();
    }

    private SearchHandler createSubTaskSearchHandler() {
        String fieldId = "subtasks";
        SubTaskManager subTaskManager = (SubTaskManager)this.locator.getComponentInstanceOfType(SubTaskManager.class);
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(new IssueParentPermissionChecker(subTaskManager));
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(clausePermissionHandler, "subtasks", new ClauseNames("subtasks"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)noOpClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createProgressSearchHandler() {
        String fieldId = "progress";
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(this.createTimeTrackingPermissionHandler(), "progress", new ClauseNames("progress"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)noOpClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createIssueParentSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forIssueParent()).setClauseQueryFactoryType(IssueParentClauseQueryFactory.class).setClauseValidatorType(IssueParentValidator.class).setContextFactory((ClauseContextFactory)this.locator.getComponentInstanceOfType(IssueParentClauseContextFactory.class)).setPermissionHandler(new DefaultClausePermissionHandler(new IssueParentPermissionChecker((SubTaskManager)this.locator.getComponentInstanceOfType(SubTaskManager.class)), this.factory.createObject(IssueClauseValueSanitiser.class, new Object[0]))).addIndexer(this.factory.createObject(ParentIssueIndexer.class, new Object[0])).build();
    }

    private SearchHandler createCurrentEstimateSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forCurrentEstimate()).setClauseQueryFactoryType(CurrentEstimateClauseQueryFactory.class).setClauseValidatorType(CurrentEstimateValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).addIndexer(this.factory.createObject(CurrentEstimateIndexer.class, new Object[0])).build();
    }

    private SearchHandler createOriginalEstimateSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forOriginalEstimate()).setClauseQueryFactoryType(OriginalEstimateClauseQueryFactory.class).setClauseValidatorType(OriginalEstimateValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).addIndexer(this.factory.createObject(OriginalEstimateIndexer.class, new Object[0])).build();
    }

    private SearchHandler createTimeSpentSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forTimeSpent()).setClauseQueryFactoryType(TimeSpentClauseQueryFactory.class).setClauseValidatorType(TimeSpentValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).addIndexer(this.factory.createObject(TimeSpentIndexer.class, new Object[0])).build();
    }

    private SearchHandler createSecurityLevelSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forSecurityLevel()).setClauseQueryFactoryType(IssueSecurityLevelClauseQueryFactory.class).setClauseValidatorType(IssueSecurityLevelClauseValidator.class).setContextFactory(this.decorateWithMultiContextFactory(((IssueSecurityLevelClauseContextFactory.Creator)this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseContextFactory.Creator.class)).create())).setPermissionHandler(this.createClausePermissionHandler(SystemSearchConstants.forSecurityLevel().getFieldId())).addIndexer(this.factory.createObject(SecurityIndexer.class, new Object[0])).buildWithValuesGenerator(new SecurityLevelClauseValuesGenerator((IssueSecurityLevelManager)this.locator.getComponentInstanceOfType(IssueSecurityLevelManager.class)));
    }

    private SearchHandler createVotesSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forVotes()).setClauseQueryFactoryType(VotesClauseQueryFactory.class).setClauseValidatorType(VotesValidator.class).setPermissionChecker(new VotePermissionChecker((VoteManager)this.locator.getComponentInstanceOfType(VoteManager.class))).build();
    }

    private SearchHandler createVoterSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forVoters()).setClauseQueryFactoryType(VoterClauseQueryFactory.class).setClauseValidatorType(UserCustomFieldValidator.class).setPermissionChecker(new VotePermissionChecker((VoteManager)this.locator.getComponentInstanceOfType(VoteManager.class))).addIndexer(this.factory.createObject(VoterIndexer.class, new Object[0])).build();
    }

    private SearchHandler createWatchesSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forWatches()).setClauseQueryFactoryType(WatchesClauseQueryFactory.class).setClauseValidatorType(WatchesValidator.class).setPermissionChecker(new WatchPermissionChecker((WatcherManager)this.locator.getComponentInstanceOfType(WatcherManager.class))).addIndexer(this.factory.createObject(WatcherIndexer.class, new Object[0])).build();
    }

    private SearchHandler createWatcherSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forWatchers()).setClauseQueryFactoryType(WatcherClauseQueryFactory.class).setClauseValidatorType(UserCustomFieldValidator.class).setPermissionChecker(new WatchPermissionChecker((WatcherManager)this.locator.getComponentInstanceOfType(WatcherManager.class))).addIndexer(this.factory.createObject(WatcherIndexer.class, new Object[0])).build();
    }

    private SearchHandler createAttachmentsSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forAttachments()).setClauseQueryFactoryType(AttachmentClauseQueryFactory.class).setClauseValidatorType(AttachmentsClauseValidator.class).setPermissionChecker((ClausePermissionChecker)this.createClausePermissionHandler("attachment")).addIndexer(this.factory.createObject(AttachmentIndexer.class, new Object[0])).build();
    }

    private SearchHandler createIssuePropertySearchHandler() {
        return this.searchHandlers.builder(SystemSearchConstants.forIssueProperty()).setClauseQueryFactoryType(IssuePropertyClauseQueryFactory.class).setClauseValidatorType(IssuePropertyClauseValidator.class).setPermissionChecker(new IssuePropertyClausePermissionChecker()).build();
    }

    private SearchHandler createProjectCategoryHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forProjectCategory()).setClauseQueryFactoryType(ProjectCategoryClauseQueryFactory.class).setClauseValidatorType(ProjectCategoryValidator.class).setContextFactory(this.decorateWithMultiContextFactory((ClauseContextFactory)this.locator.getComponent(ProjectCategoryClauseContextFactory.class))).setPermissionHandler(DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER).buildWithValuesGenerator(new ProjectCategoryClauseValuesGenerator((ProjectManager)this.locator.getComponentInstanceOfType(ProjectManager.class)));
    }

    private SearchHandler createLastViewedHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forLastViewedDate()).setClauseQueryFactoryType(LastViewedDateClauseQueryFactory.class).setClauseValidatorType(LastViewedDateValidator.class).setPermissionHandler(DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER).build();
    }

    private SearchHandler createStatusCategorySearchHandler() {
        StatusCategoryManager statusCategoryManager = (StatusCategoryManager)this.locator.getComponentInstanceOfType(StatusCategoryManager.class);
        return this.searchHandlers.builder(SystemSearchConstants.forStatusCategory()).setClauseQueryFactoryType(StatusCategoryClauseQueryFactory.class).setClauseValidatorType(StatusCategoryValidator.class).setPermissionChecker(new StatusCategoryPermissionChecker(statusCategoryManager)).buildWithValuesGenerator(new StatusCategoryClauseValuesGenerator(statusCategoryManager));
    }

    private SearchHandler createWorklogDateSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forWorklogDate()).setClauseQueryFactoryType(WorklogDateClauseQueryFactory.class).setClauseValidatorType(LocalDateValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).build();
    }

    private SearchHandler createWorklogAuthorSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forWorklogAuthor()).setClauseQueryFactoryType(WorklogAuthorClauseQueryFactory.class).setClauseValidatorType(UserCustomFieldValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).buildWithValuesGenerator((ClauseValuesGenerator)this.factory.createObject(UserClauseValuesGenerator.class, new Object[0]));
    }

    private SearchHandler createWorklogCommentSearchHandler() {
        return this.searchHandlers.builder((ClauseInformation)SystemSearchConstants.forWorklogComment()).setClauseQueryFactoryType(WorklogCommentClauseQueryFactory.class).setClauseValidatorType(DescriptionValidator.class).setPermissionHandler(this.createTimeTrackingPermissionHandler()).build();
    }

    private ClausePermissionHandler createTimeTrackingPermissionHandler() {
        ApplicationProperties applicationProperties = (ApplicationProperties)this.locator.getComponentInstanceOfType(ApplicationProperties.class);
        return new DefaultClausePermissionHandler(new TimeTrackingPermissionChecker(this.fieldClausePermissionHandlerFactory, applicationProperties));
    }

    private ClausePermissionHandler createClausePermissionHandler(String fieldId) {
        return new DefaultClausePermissionHandler(this.fieldClausePermissionHandlerFactory.createPermissionChecker(fieldId));
    }

    private ClauseContextFactory decorateWithMultiContextFactory(ClauseContextFactory factory) {
        MultiClauseDecoratorContextFactory.Factory multiFactory = (MultiClauseDecoratorContextFactory.Factory)this.locator.getComponentInstanceOfType(MultiClauseDecoratorContextFactory.Factory.class);
        return multiFactory.create(factory);
    }

    private ClauseContextFactory decorateWithValidatingContextFactory(ClauseContextFactory factory) {
        return new ValidatingDecoratorContextFactory((OperatorUsageValidator)this.locator.getComponentInstanceOfType(OperatorUsageValidator.class), factory);
    }
}

