/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.priority;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityIssueSearcher;
import com.atlassian.jira.issue.priority.PrioritySchemeMapping;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class PrioritySchemeMigrator {
    private final PrioritySchemeManager prioritySchemeManager;
    private final PriorityIssueSearcher priorityIssueSearcher;
    private final IssueManager issueManager;
    private final IssueIndexManager issueIndexManager;
    private final I18nHelper i18nHelper;
    private final PrioritySchemeService prioritySchemeService;

    public PrioritySchemeMigrator(PrioritySchemeManager prioritySchemeManager, PriorityIssueSearcher priorityIssueSearcher, IssueManager issueManager, IssueIndexManager issueIndexManager, I18nHelper i18nHelper, PrioritySchemeService prioritySchemeService) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.priorityIssueSearcher = priorityIssueSearcher;
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
        this.i18nHelper = i18nHelper;
        this.prioritySchemeService = prioritySchemeService;
    }

    public ServiceOutcome<Long> migrateSingleProject(Project project, FieldConfigScheme newPriorityScheme, Map<Priority, Priority> mapping, ApplicationUser user) {
        return this.migrateSingleProject(project, newPriorityScheme, mapping, user, TaskProgressSink.NULL_SINK);
    }

    public ServiceOutcome<Long> migrateSingleProject(Project project, FieldConfigScheme newPriorityScheme, Map<Priority, Priority> mapping, ApplicationUser user, TaskProgressSink progressSink) {
        PrioritySchemeMapping multiProjectMapping = new PrioritySchemeMapping(newPriorityScheme);
        multiProjectMapping.addAffectedProjects((Collection<Project>)ImmutableList.of((Object)project));
        for (Map.Entry<Priority, Priority> entry : mapping.entrySet()) {
            multiProjectMapping.addPriorityMapping(this.prioritySchemeManager.getScheme(project).getId(), entry.getKey(), entry.getValue());
        }
        return this.migrate(multiProjectMapping, user, progressSink);
    }

    public ServiceOutcome<Long> migrate(PrioritySchemeMapping mapping, ApplicationUser user) {
        return this.migrate(mapping, user, TaskProgressSink.NULL_SINK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceOutcome<Long> migrate(PrioritySchemeMapping mapping, ApplicationUser user, TaskProgressSink progressSink) {
        HashMultimap prioritiesToChange = HashMultimap.create();
        for (Project project2 : mapping.getAffectedProjects()) {
            prioritiesToChange.putAll((Object)project2, mapping.getPriorityMappingForProject(this.prioritySchemeManager, project2).keySet());
        }
        long issuesToChange = prioritiesToChange.entries().stream().mapToLong(entry -> this.priorityIssueSearcher.countIssuesWithPriority((Project)entry.getKey(), (Priority)entry.getValue())).sum();
        ProgressLog progressLog = new ProgressLog(progressSink, issuesToChange);
        progressLog.currentTask(this.i18nHelper.getText("admin.schemes.priority.associate.step.issues"));
        try {
            this.issueIndexManager.hold();
            long issueCount = mapping.getAffectedProjects().stream().flatMap(project -> this.mapPriorities((Project)project, mapping.getPriorityMappingForProject(this.prioritySchemeManager, (Project)project), user)).map(x -> {
                progressLog.increment();
                return x;
            }).count();
            progressLog.currentTask(this.i18nHelper.getText("admin.schemes.priority.associate.step.projects"));
            for (Project project3 : mapping.getAffectedProjects()) {
                this.prioritySchemeService.assignProject(user, mapping.getTargetScheme(), project3);
            }
            progressLog.currentTask(this.i18nHelper.getText("admin.schemes.priority.associate.step.indexing"));
            Object object = ServiceOutcomeImpl.ok(issueCount);
            return object;
        }
        finally {
            try {
                this.issueIndexManager.release();
            }
            catch (IndexException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Stream<Long> mapPriorities(Project project, Map<Priority, Priority> mapping, ApplicationUser user) {
        return mapping.entrySet().stream().flatMap(singleMapping -> this.mapSinglePriority(project, (Map.Entry<Priority, Priority>)singleMapping, user));
    }

    private Stream<Long> mapSinglePriority(Project project, Map.Entry<Priority, Priority> mapping, ApplicationUser user) {
        Priority source = mapping.getKey();
        Priority target = mapping.getValue();
        return this.priorityIssueSearcher.findIssuesWithPriority(project, source).stream().map(issueId -> {
            this.updateIssue(user, target, (long)issueId);
            return issueId;
        });
    }

    private void updateIssue(ApplicationUser user, Priority priority, long issueId) {
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueId));
        issue.setPriority(priority);
        this.issueManager.updateIssue(user, issue, EventDispatchOption.ISSUE_UPDATED, false);
    }

    private static class ProgressLog {
        private final TaskProgressSink progressSink;
        private final long total;
        private final AtomicLong done = new AtomicLong(0L);
        private volatile String currentTask;

        ProgressLog(TaskProgressSink progressSink, long total) {
            this.progressSink = progressSink;
            this.total = total;
        }

        private void increment() {
            this.progressSink.makeProgress((long)ProgressLog.percentage(this.done.incrementAndGet(), this.total), this.currentTask, null);
        }

        private void currentTask(String taskName) {
            this.currentTask = taskName;
            this.progressSink.makeProgress((long)ProgressLog.percentage(this.done.get(), this.total), this.currentTask, null);
        }

        private static int percentage(long changed, long total) {
            return (int)Math.ceil((double)changed / (double)total * 100.0);
        }
    }
}

