/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.IssueSearchExtractor;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.util.Streams;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONTokener;
import com.atlassian.query.clause.Property;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuePropertySearchExtractor
implements IssueSearchExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(IssuePropertySearchExtractor.class);
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final PluginIndexConfigurationManager entityPropertyIndexDocumentManager;
    private final DoubleConverter doubleConverter;
    private final Set<DateTimeFormatter> dateTimeFormatters;
    private final Set<DateTimeFormatter> dateOnlyFormatters;

    public IssuePropertySearchExtractor(JsonEntityPropertyManager jsonEntityPropertyManager, PluginIndexConfigurationManager entityPropertyIndexDocumentManager, DateTimeFormatterFactory dateTimeFormatterFactory, SearchExtractorRegistrationManager searchExtractorRegistrationManager, DoubleConverter doubleConverter) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.entityPropertyIndexDocumentManager = entityPropertyIndexDocumentManager;
        this.doubleConverter = doubleConverter;
        this.dateOnlyFormatters = ImmutableSet.of((Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withDefaultLocale());
        this.dateTimeFormatters = ImmutableSet.of((Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_TIME_PICKER).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME).withDefaultLocale());
        searchExtractorRegistrationManager.register(this, Issue.class);
    }

    public Set<String> indexEntity(EntitySearchExtractor.Context<Issue> ctx, Document doc) {
        Iterable<PluginIndexConfiguration> configurations = this.entityPropertyIndexDocumentManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        List indexDocumentConfigurations = (List)this.asStream(configurations).map(PluginIndexConfiguration::getIndexDocumentConfiguration).collect(CollectorsUtil.toImmutableList());
        indexDocumentConfigurations.stream().flatMap(conf -> this.documentConfigurationToFields((Issue)ctx.getEntity(), (IndexDocumentConfiguration)conf).stream()).forEach(arg_0 -> ((Document)doc).add(arg_0));
        return indexDocumentConfigurations.stream().flatMap(i -> i.getKeyConfigurations().stream()).flatMap(conf -> this.takeFieldIds((IndexDocumentConfiguration.KeyConfiguration)conf).stream()).collect(Collectors.toSet());
    }

    public List<IndexableField> documentConfigurationToFields(Issue issue, IndexDocumentConfiguration indexDocumentConfiguration) {
        List keys = (List)indexDocumentConfiguration.getKeyConfigurations().stream().map(IndexDocumentConfiguration.KeyConfiguration::getPropertyKey).collect(CollectorsUtil.toImmutableList());
        Long issueId = issue.getId();
        Map entityProperties = this.jsonEntityPropertyManager.get(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), issueId, keys);
        return (List)indexDocumentConfiguration.getKeyConfigurations().stream().flatMap(conf -> this.keyConfigurationToFields(issueId, entityProperties, (IndexDocumentConfiguration.KeyConfiguration)conf).stream()).collect(CollectorsUtil.toImmutableList());
    }

    private Set<String> takeFieldIds(IndexDocumentConfiguration.KeyConfiguration conf) {
        return conf.getExtractorConfigurations().stream().map(c -> this.fieldNameByKeyAndPath(conf.getPropertyKey(), c.getPath())).collect(Collectors.toSet());
    }

    public List<IndexableField> keyConfigurationToFields(Long issueId, Map<String, EntityProperty> entityProperties, IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
        EntityProperty entityProperty = entityProperties.get(keyConfiguration.getPropertyKey());
        if (entityProperty == null) {
            return Collections.emptyList();
        }
        Option<Object> jsonEntityProperty = this.getJSON(entityProperty.getValue(), issueId, keyConfiguration.getPropertyKey());
        if (jsonEntityProperty.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)keyConfiguration.getExtractorConfigurations().stream().flatMap(conf -> this.extractConfigurationToFields(jsonEntityProperty.get(), keyConfiguration.getPropertyKey(), (IndexDocumentConfiguration.ExtractConfiguration)conf).stream()).collect(CollectorsUtil.toImmutableList());
    }

    public List<IndexableField> extractConfigurationToFields(Object jsonEntityProperty, String key, IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
        String path = extractConfiguration.getPath();
        Option<Object> value = this.getValueForPath(jsonEntityProperty, path);
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        Object jsonValue = value.get();
        if (jsonValue instanceof JSONArray) {
            JSONArray array = (JSONArray)jsonValue;
            ImmutableList.Builder fieldsForArray = ImmutableList.builder();
            for (int i = 0; i < array.length(); ++i) {
                Object arrayElement = array.opt(i);
                if (arrayElement == null) continue;
                fieldsForArray.addAll(this.getValueFromJsonObject(arrayElement, path, key, extractConfiguration.getType()));
            }
            return fieldsForArray.build();
        }
        return this.getValueFromJsonObject(jsonValue, path, key, extractConfiguration.getType());
    }

    private Option<Object> getJSON(String jsonString, Long issueId, String entityKey) {
        try {
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            Object value = jsonTokener.nextValue();
            if (jsonTokener.more()) {
                return Option.none();
            }
            return Option.some((Object)value);
        }
        catch (JSONException e) {
            String message = MessageFormat.format("JSON stored in jsonEntityPropertyManagers is not valid for entityId='{'0'}' , entityName='{'1'}', entityKey='{'3'}'{0}", issueId.toString(), EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), entityKey);
            LOG.debug(message, (Throwable)e);
            return Option.none();
        }
    }

    private String fieldNameByKeyAndPath(String key, String path) {
        return "ISSUEPROP_" + new Property((List)ImmutableList.of((Object)key), (List)ImmutableList.of((Object)path)).getAsPropertyString();
    }

    private List<IndexableField> getValueFromJsonObject(Object value, String path, String key, IndexDocumentConfiguration.Type type) {
        if (value instanceof JSONObject || value instanceof JSONArray || value == null) {
            return Collections.emptyList();
        }
        String fieldName = this.fieldNameByKeyAndPath(key, path);
        String fieldValue = value.toString();
        boolean analyze = false;
        switch (type) {
            case NUMBER: {
                try {
                    fieldValue = this.doubleConverter.getStringForLucene(fieldValue);
                    break;
                }
                catch (FieldValidationException e) {
                    LOG.debug(MessageFormat.format("Not adding field with name {0}, value {1} is invalid message {3}", fieldName, value, e.getMessage()));
                    return Collections.emptyList();
                }
            }
            case DATE: {
                Optional<Date> dateOption = this.getDateValue(fieldValue);
                if (!dateOption.isPresent()) {
                    LOG.debug(MessageFormat.format("Not adding field with name {0}, value {1} cannot be parsed as date", fieldName, value));
                    return Collections.emptyList();
                }
                long timestamp = dateOption.get().getTime();
                return ImmutableList.of((Object)new LongPoint(fieldName, new long[]{timestamp}), (Object)new NumericDocValuesField(fieldName, timestamp));
            }
            case TEXT: {
                analyze = true;
                break;
            }
        }
        if (analyze) {
            return ImmutableList.of((Object)new TextField(fieldName, fieldValue, Field.Store.NO), (Object)new SortedDocValuesField(fieldName, new BytesRef((CharSequence)fieldValue)));
        }
        return ImmutableList.of((Object)new StringField(fieldName, fieldValue, Field.Store.NO), (Object)new SortedDocValuesField(fieldName, new BytesRef((CharSequence)fieldValue)));
    }

    private Optional<Date> getDateValue(String value) {
        Optional<Date> parsedDate = this.parseDateWithFormatter(value, this.dateTimeFormatters);
        if (parsedDate.isPresent()) {
            return parsedDate;
        }
        return this.parseDateWithFormatter(value, this.dateOnlyFormatters);
    }

    private Optional<Date> parseDateWithFormatter(String value, Iterable<DateTimeFormatter> formatters) {
        for (DateTimeFormatter formatter : formatters) {
            try {
                Date parsedDate = formatter.parse(value);
                return Optional.ofNullable(parsedDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Optional.empty();
    }

    private Option<Object> getValueForPath(Object jsonEntityProperty, String path) {
        String[] split = StringUtils.split((String)path, (char)'.');
        Object value = jsonEntityProperty;
        for (String currentKey : split) {
            if (value == null || !(value instanceof JSONObject)) {
                return Option.none();
            }
            value = ((JSONObject)value).opt(currentKey);
        }
        return Option.option((Object)value);
    }

    private <T> Stream<T> asStream(Iterable<T> configurations) {
        return Streams.stream(configurations);
    }
}

