/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.GroupConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class GroupCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final GroupConverter groupConverter;

    public GroupCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, GroupConverter groupConverter) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.groupConverter = groupConverter;
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            String lowerCaseValue = IdentifierUtils.toLowerCase((String)this.groupConverter.getString((Group)value));
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), lowerCaseValue, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)lowerCaseValue)));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), lowerCaseValue));
            }
            SecurityIndexingUtils.indexPermissions((Document)doc, (Issue)issue, (String)this.getDocumentFieldId(), (String)IdentifierUtils.toLowerCase((String)this.groupConverter.getString((Group)value)));
        }
    }
}

