/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class CurrentEstimateIndexer
extends BaseFieldIndexer {
    private final ApplicationProperties applicationProperties;

    public CurrentEstimateIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        super(fieldVisibilityManager);
        this.applicationProperties = applicationProperties;
    }

    public String getId() {
        return SystemSearchConstants.forCurrentEstimate().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forCurrentEstimate().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    public void addIndex(Document doc, Issue issue) {
        this.indexLongAsPaddedKeywordWithDefault(doc, this.getDocumentFieldId(), issue.getEstimate(), "-1", issue);
    }
}

