/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

@NonInjectableComponent
public class CascadingSelectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    public static final String CHILD_INDEX_SUFFIX = ":1";
    public static final String PARENT_AND_CHILD_INDEX_SUFFIX = "_combined";
    public static final String PARENT_AND_CHILD_INDEX_SEPARATOR = "|";
    private final CustomField customField;

    public CascadingSelectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Map) {
            Map cascadingOptions = (Map)value;
            this.indexParentField(cascadingOptions, doc, searchable);
            this.indexChildField(cascadingOptions, doc, searchable);
            this.indexParentAndChildField(cascadingOptions, doc, searchable);
        }
    }

    private void indexParentField(Map<String, Option> cascadingOptions, Document doc, boolean searchable) {
        Option value = cascadingOptions.get(CascadingSelectCFType.PARENT_KEY);
        if (value != null) {
            this.addField(doc, this.getDocumentFieldId(), value.getOptionId().toString(), searchable);
        }
    }

    private void indexChildField(Map<String, Option> cascadingOptions, Document doc, boolean searchable) {
        Option value = cascadingOptions.get("1");
        if (value != null) {
            String indexFieldName = this.getDocumentFieldId() + CHILD_INDEX_SUFFIX;
            this.addField(doc, indexFieldName, value.getOptionId().toString(), searchable);
        }
    }

    private void indexParentAndChildField(Map<String, Option> cascadingOptions, Document doc, boolean searchable) {
        Option parentValue = cascadingOptions.get(CascadingSelectCFType.PARENT_KEY);
        Option childValue = cascadingOptions.get("1");
        if (parentValue != null) {
            String combinedStringValue = null;
            combinedStringValue = childValue != null ? parentValue.getOptionId().toString() + PARENT_AND_CHILD_INDEX_SEPARATOR + childValue.getOptionId().toString() : parentValue.getOptionId().toString() + PARENT_AND_CHILD_INDEX_SEPARATOR;
            String indexFieldName = this.getDocumentFieldId() + PARENT_AND_CHILD_INDEX_SUFFIX;
            this.addField(doc, indexFieldName, combinedStringValue, searchable);
        }
    }

    private void addField(Document doc, String indexFieldName, String value, boolean searchable) {
        if (searchable) {
            doc.add((IndexableField)new StringField(indexFieldName, value, Field.Store.YES));
            doc.add((IndexableField)new SortedDocValuesField(indexFieldName, new BytesRef((CharSequence)value)));
        } else {
            doc.add((IndexableField)new StoredField(indexFieldName, value));
        }
    }
}

