/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.lucenelegacy.NumberTools;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFieldIndexer
implements FieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(BaseFieldIndexer.class);
    protected final FieldVisibilityManager fieldVisibilityManager;

    protected BaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager) {
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public void indexKeyword(Document doc, String indexField, String fieldValue, Issue issue) {
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((IndexableField)new StringField(indexField, fieldValue, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(indexField, new BytesRef((CharSequence)fieldValue)));
            } else {
                doc.add((IndexableField)new StoredField(indexField, fieldValue));
            }
        }
    }

    public void indexKeywords(Document doc, String indexField, String fieldValue, Issue issue) {
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((IndexableField)new StringField(indexField, fieldValue, Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(indexField, new BytesRef((CharSequence)fieldValue)));
            } else {
                doc.add((IndexableField)new StoredField(indexField, fieldValue));
            }
        }
    }

    public void indexFoldedKeyword(Document doc, String indexField, String fieldValue, Locale locale, Issue issue) {
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            Locale actualLocale;
            Locale locale2 = actualLocale = locale == null ? Locale.getDefault() : locale;
            if (this.isFieldVisibleAndInScope(issue)) {
                String value = CaseFolding.foldString((String)fieldValue, (Locale)actualLocale);
                doc.add((IndexableField)new StringField(indexField, value, Field.Store.NO));
                doc.add((IndexableField)new SortedDocValuesField(indexField, new BytesRef((CharSequence)value)));
            }
        }
    }

    public void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue, Issue issue) {
        FieldIndexerUtil.indexKeywordWithDefault((Document)doc, (String)indexField, (String)fieldValue, (String)defaultValue, (boolean)this.isFieldVisibleAndInScope(issue));
    }

    public void indexKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue, Issue issue) {
        String value = aLong != null ? aLong.toString() : null;
        this.indexKeywordWithDefault(doc, indexField, value, defaultValue, issue);
    }

    public void indexLongAsPaddedKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue, Issue issue) {
        String value = aLong != null ? NumberTools.longToString((long)aLong) : null;
        this.indexKeywordWithDefault(doc, indexField, value, defaultValue, issue);
    }

    public void indexLongAsPaddedKeywordWithDefault(Document doc, String indexField, Long aLong, Long defaultLong, Issue issue) {
        String defaultValue = defaultLong != null ? NumberTools.longToString((long)defaultLong) : null;
        this.indexLongAsPaddedKeywordWithDefault(doc, indexField, aLong, defaultValue, issue);
    }

    public void indexText(Document doc, String indexField, String fieldValue, Issue issue) {
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((IndexableField)new TextField(indexField, fieldValue, Field.Store.YES));
            } else {
                doc.add((IndexableField)new StoredField(indexField, fieldValue));
            }
        }
    }

    public void indexDateField(Document doc, String indexField, Timestamp date, Issue issue) {
        boolean searchable = this.isFieldVisibleAndInScope(issue);
        if (date != null) {
            if (searchable) {
                doc.add((IndexableField)new LongPoint(indexField, new long[]{this.stripMillisecondsFromDate(date)}));
                doc.add((IndexableField)new NumericDocValuesField(indexField, this.stripMillisecondsFromDate(date)));
            }
            doc.add((IndexableField)new StoredField(indexField, this.stripMillisecondsFromDate(date)));
        }
        long sortDate = searchable && date != null ? date.getTime() : Long.MAX_VALUE;
        doc.add((IndexableField)new NumericDocValuesField("sort_" + indexField, sortDate));
    }

    public void indexLocalDateField(Document doc, String indexField, LocalDate localDate, Issue issue) {
        boolean searchable = this.isFieldVisibleAndInScope(issue);
        if (localDate != null) {
            if (searchable) {
                doc.add((IndexableField)new LongPoint(indexField, new long[]{localDate.getEpochDays()}));
                doc.add((IndexableField)new NumericDocValuesField(indexField, localDate.getEpochDays()));
            }
            doc.add((IndexableField)new StoredField(indexField, localDate.getEpochDays()));
        }
        long localSortDate = searchable && localDate != null ? localDate.getEpochDays() : Long.MAX_VALUE;
        doc.add((IndexableField)new NumericDocValuesField("sort_" + indexField, localSortDate));
    }

    public void indexDependentEntities(Issue issue, Document doc, String associationType, String indexField) {
        String sinkName;
        if (associationType.equals("IssueComponent")) {
            sinkName = "Component";
        } else if (associationType.equals("IssueFixVersion")) {
            sinkName = "Version";
        } else if (associationType.equals("IssueVersion")) {
            sinkName = "Version";
        } else {
            throw new IllegalArgumentException("Assocation Type " + associationType + " not handled");
        }
        List<Long> ids = ((NodeAssociationStore)ComponentAccessor.getComponent(NodeAssociationStore.class)).getSinkIdsFromSource(issue.getGenericValue(), sinkName, associationType);
        boolean searchable = this.isFieldVisibleAndInScope(issue);
        if (ids == null || ids.isEmpty()) {
            if (searchable) {
                doc.add((IndexableField)new StringField(indexField, "-1", Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(indexField, new BytesRef((CharSequence)"-1")));
            } else {
                doc.add((IndexableField)new StoredField(indexField, "-1"));
            }
        } else {
            for (Long id : ids) {
                if (searchable) {
                    doc.add((IndexableField)new StringField(indexField, id.toString(), Field.Store.YES));
                    doc.add((IndexableField)new SortedSetDocValuesField(indexField, new BytesRef((CharSequence)id.toString())));
                    continue;
                }
                doc.add((IndexableField)new StoredField(indexField, id.toString()));
            }
        }
    }

    public void indexLongAsKeyword(Document doc, String indexField, Long fieldValue, Issue issue) {
        if (fieldValue != null) {
            boolean searchable = this.isFieldVisibleAndInScope(issue);
            if (searchable) {
                doc.add((IndexableField)new StringField(indexField, fieldValue.toString(), Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(indexField, new BytesRef((CharSequence)fieldValue.toString())));
            } else {
                doc.add((IndexableField)new StoredField(indexField, fieldValue.toString()));
            }
        }
    }

    public void indexTextForSorting(Document doc, String indexField, String fieldValue, Issue issue) {
        String string = FieldIndexerUtil.getValueForSorting((String)fieldValue);
        if (StringUtils.isNotBlank((CharSequence)string) && this.isFieldVisibleAndInScope(issue)) {
            doc.add((IndexableField)new SortedDocValuesField(indexField, new BytesRef((CharSequence)string)));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldIndexer)) {
            return false;
        }
        FieldIndexer rhs = (FieldIndexer)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }

    public int hashCode() {
        return this.getId().hashCode() * 41;
    }

    public int compareTo(Object obj) {
        FieldIndexer o = (FieldIndexer)obj;
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).toComparison();
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return !this.fieldVisibilityManager.isFieldHidden(this.getId(), issue);
    }

    private long stripMillisecondsFromDate(Date date) {
        return date.getTime() / 1000L * 1000L;
    }
}

