/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;

public class FieldIndexerWithStats
implements FieldIndexer {
    private final FieldIndexer delegate;
    private final boolean isKnown;
    private final MutableFieldIndexerStats stats = new MutableFieldIndexerStats();
    private Ticker ticker = Ticker.systemTicker();

    private FieldIndexerWithStats(boolean isKnown, FieldIndexer delegate) {
        this.isKnown = isKnown;
        this.delegate = delegate;
    }

    public FieldIndexerWithStats overrideTicker(Ticker ticker) {
        Preconditions.checkNotNull((Object)ticker);
        this.ticker = ticker;
        return this;
    }

    public static FieldIndexerWithStats createKnown(FieldIndexer delegate) {
        return new FieldIndexerWithStats(true, delegate);
    }

    public static FieldIndexerWithStats createOther(FieldIndexer delegate) {
        return new FieldIndexerWithStats(false, delegate);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getDocumentFieldId() {
        return this.delegate.getDocumentFieldId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(Document doc, Issue issue) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        try {
            this.delegate.addIndex(doc, issue);
        }
        finally {
            this.stats.addIndex(stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldVisibleAndInScope(Issue issue) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        try {
            boolean bl = this.delegate.isFieldVisibleAndInScope(issue);
            return bl;
        }
        finally {
            this.stats.isFieldVisibleAndInScope(stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldIndexerWithStats that = (FieldIndexerWithStats)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldIndexerWithStats{");
        sb.append("delegate=").append(this.delegate);
        sb.append(", isKnown=").append(this.isKnown);
        sb.append(", stats=").append(this.stats);
        sb.append('}');
        return sb.toString();
    }

    public Stats stats() {
        return new Stats(this);
    }

    public Stats resetSnapshot() {
        try {
            Stats stats = this.stats();
            return stats;
        }
        finally {
            this.stats.resetSnapshot();
        }
    }

    public void reset() {
        this.stats.reset();
    }

    public static class Stats {
        private final boolean isKnown;
        private final String id;
        private final String documentFieldId;
        private final LongStats totalTimeToAddIndexMicros;
        private final LongStats snapshotTimeToAddIndexMicros;
        private final LongStats totalTimeToIsFieldVisibleAndInScopeMicros;
        private final LongStats snapshotTimeToIsFieldVisibleAndInScopeMicros;

        Stats(FieldIndexerWithStats fieldIndexerWithStats) {
            this.isKnown = fieldIndexerWithStats.isKnown;
            this.id = fieldIndexerWithStats.getId();
            this.documentFieldId = fieldIndexerWithStats.getDocumentFieldId();
            this.totalTimeToAddIndexMicros = fieldIndexerWithStats.stats.totalTimeToAddIndexMicros.get();
            this.snapshotTimeToAddIndexMicros = fieldIndexerWithStats.stats.snapshotTimeToAddIndexMicros.get();
            this.totalTimeToIsFieldVisibleAndInScopeMicros = fieldIndexerWithStats.stats.totalTimeToIsFieldVisibleAndInScopeMicros.get();
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros = fieldIndexerWithStats.stats.snapshotTimeToIsFieldVisibleAndInScopeMicros.get();
        }

        public boolean isKnown() {
            return this.isKnown;
        }

        public String id() {
            return this.id;
        }

        public String documentFieldId() {
            return this.documentFieldId;
        }

        public LongStats totalTimeToAddIndexMicros() {
            return this.totalTimeToAddIndexMicros;
        }

        public LongStats snapshotTimeToAddIndexMicros() {
            return this.snapshotTimeToAddIndexMicros;
        }

        public LongStats totalTimeToIsFieldVisibleAndInScopeMicros() {
            return this.totalTimeToIsFieldVisibleAndInScopeMicros;
        }

        public LongStats snapshotTimeToIsFieldVisibleAndInScopeMicros() {
            return this.snapshotTimeToIsFieldVisibleAndInScopeMicros;
        }
    }

    private static class MutableFieldIndexerStats {
        private final MutableLongStats totalTimeToAddIndexMicros = new MutableLongStats();
        private final MutableLongStats snapshotTimeToAddIndexMicros = new MutableLongStats();
        private final MutableLongStats totalTimeToIsFieldVisibleAndInScopeMicros = new MutableLongStats();
        private final MutableLongStats snapshotTimeToIsFieldVisibleAndInScopeMicros = new MutableLongStats();

        private MutableFieldIndexerStats() {
        }

        void addIndex(long timeToAddMicros) {
            this.totalTimeToAddIndexMicros.accept(timeToAddMicros);
            this.snapshotTimeToAddIndexMicros.accept(timeToAddMicros);
        }

        void isFieldVisibleAndInScope(long timeToAddMicros) {
            this.totalTimeToIsFieldVisibleAndInScopeMicros.accept(timeToAddMicros);
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros.accept(timeToAddMicros);
        }

        void resetSnapshot() {
            this.snapshotTimeToAddIndexMicros.reset();
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros.reset();
        }

        void resetTotal() {
            this.totalTimeToAddIndexMicros.reset();
            this.totalTimeToIsFieldVisibleAndInScopeMicros.reset();
        }

        void reset() {
            this.resetSnapshot();
            this.resetTotal();
        }
    }
}

