/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.util.DatabaseIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

class IssueIdBatcher
implements IssuesBatcher {
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;
    private final int batchSize;
    private final Spy spy;
    private final ImmutableList<String> orderBy = ImmutableList.of((Object)"id DESC");
    private EntityCondition condition;
    private final Barrier reindexingBarrier;
    private long maxIdNextBatch;

    IssueIdBatcher(OfBizDelegator delegator, IssueFactory issueFactory, BarrierFactory barrierFactory, int batchSize, EntityCondition condition, Spy spy) {
        this.delegator = delegator;
        this.issueFactory = issueFactory;
        this.batchSize = batchSize;
        this.spy = spy;
        this.maxIdNextBatch = this.selectMaxId();
        this.condition = null;
        this.condition = condition;
        this.reindexingBarrier = barrierFactory.getBarrier("reindexing");
    }

    @Override
    public Iterator<IssuesIterable> iterator() {
        return new IssuesIterator();
    }

    private long selectMaxId() {
        GenericValue maxGV = EntityUtil.getOnly((List)this.delegator.findByCondition("IssueMaxId", null, (Collection)ImmutableList.of((Object)"max")));
        if (maxGV == null) {
            return -1L;
        }
        Long max = maxGV.getLong("max");
        return max != null ? max : -1L;
    }

    static interface Spy {
        public void spy(Issue var1);
    }

    private class SpyingIssuesIterable
    extends DatabaseIssuesIterable {
        private final Spy spy;

        SpyingIssuesIterable(OfBizDelegator delegator, @Nullable IssueFactory issueFactory, @Nullable EntityCondition condition, @Nullable List<String> orderBy, EntityFindOptions findOptions, Spy spy) {
            super(delegator, issueFactory, condition, orderBy, findOptions);
            this.spy = spy;
        }

        @Override
        protected void spy(Issue next) {
            if (this.spy != null) {
                this.spy.spy(next);
            }
            IssueIdBatcher.this.reindexingBarrier.await();
            IssueIdBatcher.this.maxIdNextBatch = Math.min(IssueIdBatcher.this.maxIdNextBatch, next.getId() - 1L);
        }
    }

    private class IssuesIterator
    extends AbstractIterator<IssuesIterable> {
        private IssuesIterator() {
        }

        protected IssuesIterable computeNext() {
            if (IssueIdBatcher.this.maxIdNextBatch < 0L) {
                return (IssuesIterable)this.endOfData();
            }
            EntityExpr idCondition = new EntityExpr("id", EntityOperator.LESS_THAN_EQUAL_TO, (Object)IssueIdBatcher.this.maxIdNextBatch);
            EntityExpr where = IssueIdBatcher.this.condition == null ? idCondition : new EntityConditionList((List)ImmutableList.of((Object)idCondition, (Object)IssueIdBatcher.this.condition), EntityOperator.AND);
            IssueIdBatcher.this.maxIdNextBatch = IssueIdBatcher.this.maxIdNextBatch - (long)IssueIdBatcher.this.batchSize;
            return new SpyingIssuesIterable(IssueIdBatcher.this.delegator, IssueIdBatcher.this.issueFactory, (EntityCondition)where, (List<String>)IssueIdBatcher.this.orderBy, EntityFindOptions.findOptions().maxResults(IssueIdBatcher.this.batchSize), IssueIdBatcher.this.spy);
        }
    }
}

