/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.util.profiling.Ticker;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class DefaultChangeHistoryDocumentFactory
implements ChangeHistoryDocumentFactory {
    private final SearchExtractorRegistrationManager searchExtractorManager;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;

    public DefaultChangeHistoryDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager, IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager) {
        this.searchExtractorManager = searchExtractorManager;
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
    }

    private static String encodeChangedField(String changedField, String docConstant) {
        return changedField + '.' + docConstant;
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }

    private static String encodeProtocolPreservingCase(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem);
    }

    public Option<Document> apply(ChangeHistoryGroup changeHistoryGroup) {
        try (Ticker ignored = IndexingTimers.DOC_CREATION_CHANGEHISTORY.start(new String[0]);){
            if (changeHistoryGroup == null) {
                Option option = Option.none();
                return option;
            }
            String changeItemUser = changeHistoryGroup.getUserKey();
            Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(changeHistoryGroup).addSearchableField("projid", String.valueOf(changeHistoryGroup.getProjectId()), Field.Store.NO)).addSearchableField("issue_id", String.valueOf(changeHistoryGroup.getIssueId()), Field.Store.YES)).addSortableField("issue_id", String.valueOf(changeHistoryGroup.getIssueId()))).addSearchableField("key", String.valueOf(changeHistoryGroup.getIssueKey()), Field.Store.YES)).addSearchableField("ch_who", DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(changeItemUser), Field.Store.NO)).addSearchableField("ch_date", changeHistoryGroup.getCreated(), Field.Store.YES);
            for (ChangeHistoryItem changeItem : changeHistoryGroup.getChangeItems()) {
                String changedField = changeItem.getField();
                if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(changedField)) continue;
                builder.addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(ChangeHistoryGroup.class));
                ((Builder)builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_duration"), String.valueOf(changeItem.getDuration()), Field.Store.NO)).addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_nextchangedate"), changeItem.getNextChangeCreated(), Field.Store.NO);
                for (String from : changeItem.getFroms().values()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_from"), DefaultChangeHistoryDocumentFactory.encodeProtocol(from), Field.Store.NO);
                }
                for (String to : changeItem.getTos().values()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_to"), DefaultChangeHistoryDocumentFactory.encodeProtocol(to), Field.Store.NO);
                }
                for (String fromValue : changeItem.getFroms().keySet()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_oldvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(fromValue), Field.Store.YES);
                }
                for (String toValue : changeItem.getTos().keySet()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_newvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(toValue), Field.Store.YES);
                }
            }
            Iterator iterator = builder.build();
            return iterator;
        }
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<ChangeHistoryGroup, Builder> {
        private Builder(ChangeHistoryGroup entity) {
            super(entity, "changes");
        }

        @Override
        protected String getDocumentType() {
            return "changehistory";
        }
    }
}

