/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeFieldChangeLogHelperImpl
implements DateTimeFieldChangeLogHelper {
    private static final Logger log = LoggerFactory.getLogger(DateTimeFieldChangeLogHelperImpl.class);
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public DateTimeFieldChangeLogHelperImpl(DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public String createChangelogValueForDateTimeField(Date date) {
        return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(date);
    }

    public String createChangelogValueForDateField(Date date) {
        return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withSystemZone().format(date);
    }

    public String renderChangeHistoryValueDate(String dateValue, String dateStr) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
                Date date = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withSystemZone().parse(dateValue);
                return this.dateTimeFormatterFactory.formatter().forLoggedInUser().withSystemZone().withStyle(DateTimeStyle.DATE).format(date);
            }
            return dateStr;
        }
        catch (IllegalArgumentException ex) {
            log.debug("Failed to parse change history date string '" + dateStr + "'. Returning unformatted string.");
            return dateStr;
        }
    }

    public String renderChangeHistoryValueDateTime(String dateTimeValue, String dateTimeString) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)dateTimeValue)) {
                Date date = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).parse(dateTimeValue);
                return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_TIME_PICKER).forLoggedInUser().format(date);
            }
            return dateTimeString;
        }
        catch (IllegalArgumentException ex) {
            log.debug("Failed to parse change history date time string '" + dateTimeString + "'. Returning unformatted string.");
            return dateTimeString;
        }
    }
}

