/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.tab;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.tab.FieldScreenRenderLayoutItemFilter;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FieldScreenRenderLayoutItemFilterImpl
implements FieldScreenRenderLayoutItemFilter {
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;

    public FieldScreenRenderLayoutItemFilterImpl(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager) {
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    public Collection<FieldScreenLayoutItem> filterAvailableFieldScreenLayoutItems(final com.atlassian.jira.util.Predicate<? super Field> condition, List<FieldScreenLayoutItem> fieldLayoutItems) {
        final Set unavailableFields = this.fieldManager.getUnavailableFields();
        Predicate availableItemsPredicate = SafePluginPointAccess.safe((Predicate)new com.google.common.base.Predicate<FieldScreenLayoutItem>(){

            public boolean apply(FieldScreenLayoutItem fieldScreenLayoutItem) {
                OrderableField orderableField = fieldScreenLayoutItem.getOrderableField();
                return orderableField != null && condition.evaluate((Object)orderableField) && !unavailableFields.contains(orderableField);
            }
        });
        return Lists.newArrayList((Iterable)fieldLayoutItems.stream().filter(availableItemsPredicate).collect(Collectors.toList()));
    }

    @Override
    public Collection<FieldScreenLayoutItem> filterVisibleFieldScreenLayoutItems(final Issue issue, Collection<FieldScreenLayoutItem> fieldLayoutItems) {
        return Lists.newArrayList((Iterable)fieldLayoutItems.stream().filter(SafePluginPointAccess.safe((Predicate)new com.google.common.base.Predicate<FieldScreenLayoutItem>(){

            public boolean apply(FieldScreenLayoutItem fieldScreenLayoutItem) {
                OrderableField orderableField;
                FieldLayout fieldLayout = FieldScreenRenderLayoutItemFilterImpl.this.fieldLayoutManager.getFieldLayout(issue);
                FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField = fieldScreenLayoutItem.getOrderableField());
                return !fieldLayoutItem.isHidden() && fieldScreenLayoutItem.isShown(issue);
            }
        })).collect(Collectors.toList()));
    }
}

