/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultIssueTypeScreenSchemeManager
implements IssueTypeScreenSchemeManager {
    private final OfBizDelegator ofBizDelegator;
    private final ConstantsManager constantsManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final Cache<Long, Optional<IssueTypeScreenScheme>> schemeCache;
    private final Cache<Long, Optional<Long>> projectAssociationCache;

    public DefaultIssueTypeScreenSchemeManager(OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, FieldScreenSchemeManager fieldScreenSchemeManager, NodeAssociationStore nodeAssociationStore, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.constantsManager = constantsManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.projectAssociationCache = cacheManager.getCache(this.getClass().getName() + ".projectAssociationCache", this::loadProjectAssociation, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.schemeCache = cacheManager.getCache(this.getClass().getName() + ".schemeCache", this::loadIssueTypeScreenScheme, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public Collection<IssueTypeScreenScheme> getIssueTypeScreenSchemes() {
        return this.buildIssueTypeScreenSchemes(this.ofBizDelegator.findAll("IssueTypeScreenScheme", EasyList.build((Object)"name")));
    }

    private Collection<IssueTypeScreenScheme> buildIssueTypeScreenSchemes(List<GenericValue> issueTypeScreenSchemeGVs) {
        return issueTypeScreenSchemeGVs.stream().map(this::buildIssueTypeScreenScheme).collect(Collectors.toList());
    }

    protected IssueTypeScreenScheme buildIssueTypeScreenScheme(GenericValue genericValue) {
        return new IssueTypeScreenSchemeImpl(this, genericValue);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Long id) {
        return ((Optional)this.schemeCache.get((Object)id)).orElse(null);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        Long projectId = this.getProjectId(project);
        return ((Optional)this.projectAssociationCache.get((Object)projectId)).map(this::getIssueTypeScreenScheme).orElse(null);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Project project) {
        return this.getIssueTypeScreenScheme(project.getGenericValue());
    }

    public FieldScreenScheme getFieldScreenScheme(Issue issue) {
        Project project = issue.getProjectObject();
        if (project == null) {
            throw new RuntimeException("Issue '" + issue + "' has no project");
        }
        IssueTypeScreenScheme issueTypeScreenScheme = this.getIssueTypeScreenScheme(project.getGenericValue());
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issue.getIssueTypeId());
        if (issueTypeScreenSchemeEntity == null && (issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null)) == null) {
            throw new IllegalStateException("No default entity for issue type screen scheme with id '" + issueTypeScreenScheme.getId() + "'.");
        }
        return issueTypeScreenSchemeEntity.getFieldScreenScheme();
    }

    public Collection getIssueTypeScreenSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        LinkedList<IssueTypeScreenSchemeEntity> issueTypeScreenSchemeEntities = new LinkedList<IssueTypeScreenSchemeEntity>();
        List issueTypeScreenSchemeEntitymGVs = this.getOfBizDelegator().findByAnd("IssueTypeScreenSchemeEntity", (Map)FieldMap.build((String)"scheme", (Object)issueTypeScreenScheme.getId()));
        for (GenericValue issueTypeScreenSchemeEntityGV : issueTypeScreenSchemeEntitymGVs) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.buildIssueTypeScreenSchemeEntity(issueTypeScreenSchemeEntityGV);
            issueTypeScreenSchemeEntity.setIssueTypeScreenScheme(issueTypeScreenScheme);
            issueTypeScreenSchemeEntities.add(issueTypeScreenSchemeEntity);
        }
        return issueTypeScreenSchemeEntities;
    }

    protected IssueTypeScreenSchemeEntity buildIssueTypeScreenSchemeEntity(GenericValue genericValue) {
        IssueTypeScreenSchemeEntityImpl issueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl((IssueTypeScreenSchemeManager)this, genericValue, this.fieldScreenSchemeManager, this.constantsManager);
        issueTypeScreenSchemeEntity.setIssueTypeId(genericValue.getString("issuetype"));
        issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(genericValue.getLong("fieldscreenscheme")));
        return issueTypeScreenSchemeEntity;
    }

    public void createIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        FieldMap params = FieldMap.build((String)"name", (Object)issueTypeScreenScheme.getName(), (String)"description", (Object)issueTypeScreenScheme.getDescription());
        if (issueTypeScreenScheme.getId() != null) {
            params.put("id", issueTypeScreenScheme.getId());
        }
        GenericValue fieldScreenSchemeGV = this.ofBizDelegator.createValue("IssueTypeScreenScheme", (Map)params);
        issueTypeScreenScheme.setGenericValue(fieldScreenSchemeGV);
        this.schemeCache.remove((Object)issueTypeScreenScheme.getId());
    }

    public void updateIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.ofBizDelegator.store(issueTypeScreenScheme.getGenericValue());
        this.schemeCache.remove((Object)issueTypeScreenScheme.getId());
    }

    public void removeIssueTypeSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.getOfBizDelegator().removeByAnd("IssueTypeScreenSchemeEntity", (Map)FieldMap.build((String)"scheme", (Object)issueTypeScreenScheme.getId()));
    }

    public void removeIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.getOfBizDelegator().removeValue(issueTypeScreenScheme.getGenericValue());
        this.schemeCache.remove((Object)issueTypeScreenScheme.getId());
    }

    public void createIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        String issueTypeId = issueTypeScreenSchemeEntity.getIssueTypeId();
        GenericValue issueTypeScreenSchemeEntityGV = this.ofBizDelegator.createValue("IssueTypeScreenSchemeEntity", MapBuilder.build((Object)"issuetype", (Object)issueTypeId, (Object)"fieldscreenscheme", (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme().getId(), (Object)"scheme", (Object)issueTypeScreenSchemeEntity.getIssueTypeScreenScheme().getId()));
        issueTypeScreenSchemeEntity.setGenericValue(issueTypeScreenSchemeEntityGV);
        this.schemeCache.remove((Object)issueTypeScreenSchemeEntity.getFieldScreenScheme().getId());
    }

    public void updateIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.ofBizDelegator.store(issueTypeScreenSchemeEntity.getGenericValue());
        this.schemeCache.remove((Object)issueTypeScreenSchemeEntity.getFieldScreenScheme().getId());
    }

    public void removeIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.ofBizDelegator.removeValue(issueTypeScreenSchemeEntity.getGenericValue());
        this.schemeCache.remove((Object)issueTypeScreenSchemeEntity.getIssueTypeScreenScheme().getId());
    }

    public Collection<IssueTypeScreenScheme> getIssueTypeScreenSchemes(FieldScreenScheme fieldScreenScheme) {
        return this.ofBizDelegator.findByAnd("IssueTypeScreenSchemeEntity", (Map)FieldMap.build((String)"fieldscreenscheme", (Object)fieldScreenScheme.getId())).stream().map(gv -> gv.getLong("scheme")).distinct().map(this::getIssueTypeScreenScheme).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        try {
            IssueTypeScreenScheme oldIssueTypeScreenScheme = this.getIssueTypeScreenScheme(project);
            if (oldIssueTypeScreenScheme != null) {
                if (!oldIssueTypeScreenScheme.equals(issueTypeScreenScheme)) {
                    this.removeSchemeAssociation(project, oldIssueTypeScreenScheme);
                    if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                        this.nodeAssociationStore.createAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
                    }
                }
            } else if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                this.nodeAssociationStore.createAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
            }
        }
        finally {
            this.projectAssociationCache.remove((Object)this.getProjectId(project));
        }
    }

    public void addSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.addSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
    }

    public void removeSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        try {
            if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                this.nodeAssociationStore.removeAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
            }
        }
        finally {
            this.projectAssociationCache.remove((Object)this.getProjectId(project));
        }
    }

    public void removeSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.removeSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
    }

    public Collection<GenericValue> getProjects(IssueTypeScreenScheme issueTypeScreenScheme) {
        List<GenericValue> projects = this.nodeAssociationStore.getSourcesFromSink(issueTypeScreenScheme.getGenericValue(), "Project", "ProjectScheme");
        Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    public void associateWithDefaultScheme(GenericValue project) {
        this.addSchemeAssociation(project, this.getDefaultScheme());
    }

    public void associateWithDefaultScheme(Project project) {
        this.associateWithDefaultScheme(project.getGenericValue());
    }

    public IssueTypeScreenScheme getDefaultScheme() {
        return this.getIssueTypeScreenScheme(IssueTypeScreenScheme.DEFAULT_SCHEME_ID);
    }

    public void refresh() {
        this.schemeCache.removeAll();
        this.projectAssociationCache.removeAll();
    }

    protected OfBizDelegator getOfBizDelegator() {
        return this.ofBizDelegator;
    }

    @Nonnull
    private Optional<Long> loadProjectAssociation(@Nonnull Long projectId) {
        return Optional.ofNullable(EntityUtil.getOnly(this.nodeAssociationStore.getSinksFromSource("Project", projectId, "IssueTypeScreenScheme", "ProjectScheme"))).map(gv -> this.buildIssueTypeScreenScheme((GenericValue)gv).getId());
    }

    public Long getProjectId(GenericValue project) {
        return project == null ? null : project.getLong("id");
    }

    @Nonnull
    private Optional<IssueTypeScreenScheme> loadIssueTypeScreenScheme(@Nonnull Long id) {
        return Optional.ofNullable(this.getOfBizDelegator().findById("IssueTypeScreenScheme", id)).map(this::buildIssueTypeScreenScheme);
    }
}

